/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import snownee.cuisine.Cuisine;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Spice;
import snownee.cuisine.api.events.SpiceBottleContentConsumedEvent;
import snownee.cuisine.internal.CuisineInternalGateway;
import snownee.cuisine.util.I18nUtil;
import snownee.kiwi.item.ItemMod;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.OreUtil;
import snownee.kiwi.util.PlayerUtil;

public class ItemSpiceBottle
extends ItemMod {
    public static final String TAG_VOLUME = "volume";
    public static final int MAX_VOLUME = 10;

    public ItemSpiceBottle(String name) {
        super(name);
        this.func_77637_a(Cuisine.CREATIVE_TAB);
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void mapModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "fluid"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "item"));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new SpiceFluidHandler(stack, 1000);
    }

    @Nullable
    public SpiceItemHandler getItemHandler(ItemStack stack) {
        if (!this.hasFluid(stack)) {
            return new SpiceItemHandler(stack);
        }
        return null;
    }

    @Nullable
    public IFluidHandlerItem getFluidHandler(ItemStack stack) {
        return (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    @Nullable
    public Spice getSpice(ItemStack stack) {
        FluidStack fluidStack;
        if (this.hasItem(stack)) {
            SpiceItemHandler handler = this.getItemHandler(stack);
            if (handler != null) {
                return CulinaryHub.API_INSTANCE.findSpice(handler.getStackInSlot(0));
            }
        } else if (this.hasFluid(stack) && (fluidStack = this.getFluidHandler(stack).drain(Integer.MAX_VALUE, false)) != null) {
            return CulinaryHub.API_INSTANCE.findSpice(fluidStack);
        }
        return null;
    }

    public boolean isContainerEmpty(ItemStack stack) {
        return !this.hasFluid(stack) && !this.hasItem(stack);
    }

    public boolean hasFluid(ItemStack stack) {
        if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return false;
        }
        return this.getFluidHandler(stack).drain(Integer.MAX_VALUE, false) != null;
    }

    public boolean hasItem(ItemStack stack) {
        return stack.func_77960_j() == 1;
    }

    public boolean consume(ItemStack stack, int amount) {
        if (amount <= 10 && amount > 0) {
            int volume;
            if (this.hasFluid(stack)) {
                int amountFluid;
                IFluidHandlerItem handler = this.getFluidHandler(stack);
                FluidStack fluidStack = handler.drain(amountFluid = 1000 * amount / 10, false);
                if (fluidStack != null && fluidStack.amount == amountFluid) {
                    handler.drain(amountFluid, true);
                    return true;
                }
            } else if (this.hasItem(stack) && (volume = this.getDurability(stack)) >= amount) {
                this.setDurability(stack, volume - amount);
                return true;
            }
        }
        return false;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.isContainerEmpty(stack) ? super.getItemStackLimit(stack) : 1;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.isContainerEmpty(stack);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return this.hasContainerItem(itemStack) ? new ItemStack((Item)this) : ItemStack.field_190927_a;
    }

    public int getDurability(ItemStack stack) {
        return NBTHelper.of((ItemStack)stack).getInt(TAG_VOLUME);
    }

    public void setDurability(ItemStack stack, int durability) {
        if (durability > 0) {
            NBTHelper.of((ItemStack)stack).setInt(TAG_VOLUME, durability);
            stack.func_77964_b(1);
        } else {
            stack.func_77982_d(null);
            stack.func_77964_b(0);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.hasItem(stack) && this.getDurability(stack) != 10 || this.hasFluid(stack) && this.getFluidHandler((ItemStack)stack).drain((int)Integer.MAX_VALUE, (boolean)false).amount < 1000;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (this.hasFluid(stack)) {
            FluidStack fluidStack = this.getFluidHandler(stack).drain(Integer.MAX_VALUE, false);
            if (fluidStack == null) {
                return 0.0;
            }
            return 1.0 - (double)fluidStack.amount / 1000.0;
        }
        return 1.0 - (double)this.getDurability(stack) / 10.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.hasItem(stack)) {
            tooltip.add(I18nUtil.translateWithFormat("tip.spice.item", this.getDurability(stack)));
        } else if (this.hasFluid(stack)) {
            FluidStack fluidStack = this.getFluidHandler(stack).drain(Integer.MAX_VALUE, false);
            tooltip.add(I18nUtil.translate("tip.spice.fluid", fluidStack.amount));
        } else {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
        }
    }

    public String func_77653_i(ItemStack stack) {
        if (this.hasItem(stack)) {
            SpiceItemHandler handler = this.getItemHandler(stack);
            if (handler != null) {
                return handler.getStackInSlot(0).func_82833_r();
            }
        } else if (this.hasFluid(stack)) {
            return this.getFluidHandler(stack).drain(Integer.MAX_VALUE, false).getLocalizedName();
        }
        return super.func_77653_i(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack held = playerIn.func_184586_b(handIn);
        if (!this.isContainerEmpty(held)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(this.func_77661_b(held) == EnumAction.NONE ? EnumActionResult.PASS : EnumActionResult.SUCCESS, (Object)held);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            FluidActionResult result = FluidUtil.tryPickUpFluid((ItemStack)held, (EntityPlayer)playerIn, (World)worldIn, (BlockPos)raytraceresult.func_178782_a(), (EnumFacing)raytraceresult.field_178784_b);
            if (result.isSuccess()) {
                held.func_190918_g(1);
                return PlayerUtil.mergeItemStack((ItemStack)result.getResult(), (EntityPlayer)playerIn, (EnumHand)handIn);
            }
            BlockPos offset = new BlockPos(0, 0, 0).func_177972_a(raytraceresult.field_178784_b);
            Vec3d hit = raytraceresult.field_72307_f.func_72441_c((double)offset.func_177958_n() * 0.5, (double)offset.func_177956_o() * 0.5, (double)offset.func_177952_p() * 0.5);
            List items = worldIn.func_72872_a(EntityItem.class, new AxisAlignedBB(hit.field_72450_a - 0.5, hit.field_72448_b - 0.5, hit.field_72449_c - 0.5, hit.field_72450_a + 0.5, hit.field_72448_b + 0.5, hit.field_72449_c + 0.5));
            ItemStack heldCopy = held.func_77946_l();
            heldCopy.func_190920_e(1);
            SpiceItemHandler handler = this.getItemHandler(heldCopy);
            for (EntityItem item : items) {
                ItemStack stack = item.func_92059_d();
                if (handler == null || handler.getSlots() <= 0 || !handler.insertItem(0, stack, false).func_190926_b()) continue;
                worldIn.func_184148_a(playerIn, item.field_70165_t, item.field_70163_u, item.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                item.func_70106_y();
                held.func_190918_g(1);
                return PlayerUtil.mergeItemStack((ItemStack)heldCopy, (EntityPlayer)playerIn, (EnumHand)handIn);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)held);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (this.isContainerEmpty(stack)) {
            return stack;
        }
        if (entityLiving instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entityLiving;
            entityplayermp.func_71029_a(StatList.func_188057_b((Item)this));
        }
        FluidStack content = null;
        if (this.hasItem(stack)) {
            SpiceItemHandler handler = this.getItemHandler(stack);
            if (handler != null) {
                content = handler.getStackInSlot(0);
            }
        } else {
            content = this.getFluidHandler(stack).drain(Integer.MAX_VALUE, false);
        }
        boolean creative = false;
        if (entityLiving instanceof EntityPlayer) {
            creative = ((EntityPlayer)entityLiving).func_184812_l_();
        }
        if (content != null && creative || this.consume(stack, 10)) {
            MinecraftForge.EVENT_BUS.post((Event)new SpiceBottleContentConsumedEvent(worldIn, entityLiving, stack, content));
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (this.hasItem(stack) && this.getDurability(stack) == 10) {
            return EnumAction.DRINK;
        }
        if (this.hasFluid(stack)) {
            FluidStack fluidStack = this.getFluidHandler(stack).drain(Integer.MAX_VALUE, false);
            return fluidStack != null && fluidStack.amount == 1000 ? EnumAction.DRINK : EnumAction.NONE;
        }
        return EnumAction.NONE;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            items.add((Object)stack.func_77946_l());
            CuisineInternalGateway.INSTANCE.fluidToSpiceMapping.keySet().forEach(f -> {
                Fluid fluid = FluidRegistry.getFluid((String)f);
                if (fluid != null) {
                    ItemStack copy = stack.func_77946_l();
                    this.getFluidHandler(copy).fill(new FluidStack(fluid, 1000), true);
                    items.add((Object)copy);
                }
            });
            CuisineInternalGateway.INSTANCE.itemToSpiceMapping.keySet().forEach(id -> {
                ItemStack copy = stack.func_77946_l();
                this.getItemHandler(copy).insertItem(0, id.getItemStack(), false);
                items.add((Object)copy);
            });
            CuisineInternalGateway.INSTANCE.oreDictToSpiceMapping.keySet().forEach(ore -> {
                ItemStack copy = stack.func_77946_l();
                this.getItemHandler(copy).insertItem(0, OreUtil.getPreferredItemFromOre((String)ore), false);
                items.add((Object)copy);
            });
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        if (target.getClass() != EntityCow.class || ((EntityCow)target).func_70631_g_()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!FluidRegistry.isFluidRegistered((String)"milk") || stack.func_77973_b() != this || !this.isContainerEmpty(stack)) {
            return;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(1);
        stack.func_190918_g(1);
        this.getFluidHandler(copy).fill(new FluidStack(FluidRegistry.getFluid((String)"milk"), 1000), true);
        player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
        PlayerUtil.mergeItemStack((ItemStack)copy, (EntityPlayer)player, (EnumHand)event.getHand());
        event.setCanceled(true);
        event.setCancellationResult(EnumActionResult.SUCCESS);
    }

    public static class SpiceFluidHandler
    extends FluidHandlerItemStack {
        public SpiceFluidHandler(ItemStack container, int capacity) {
            super(container, capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return this.container.func_77960_j() == 0 && !fluid.getFluid().isGaseous(fluid) && fluid.getFluid().getTemperature(fluid) < 400 && super.canFillFluidType(fluid);
        }

        protected void setContainerToEmpty() {
            this.container.func_77982_d(null);
        }
    }

    public static class SpiceItemHandler
    extends ItemStackHandler {
        private final ItemStack container;

        public SpiceItemHandler(ItemStack container) {
            this.container = container;
            NBTTagCompound nbt = container.func_77978_p();
            if (nbt != null) {
                this.deserializeNBT(nbt);
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!CulinaryHub.API_INSTANCE.isKnownSpice(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        protected void onContentsChanged(int slot) {
            boolean empty = this.getStackInSlot(0).func_190926_b();
            this.container.func_77982_d(empty ? null : this.serializeNBT());
            if (!empty) {
                NBTHelper.of((ItemStack)this.container).setInt(ItemSpiceBottle.TAG_VOLUME, 10);
            }
            this.container.func_77964_b(empty ? 0 : 1);
        }
    }
}

