/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.items;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineRegistry;
import snownee.kiwi.item.IVariant;
import snownee.kiwi.item.ItemModVariantsNew;
import snownee.kiwi.util.PlayerUtil;

public class ItemMortar
extends ItemModVariantsNew<Void, Variant> {
    public ItemMortar(String name, Block block) {
        super(name, (IVariant[])Variant.values());
        this.func_77637_a(Cuisine.CREATIVE_TAB);
        this.func_77642_a((Item)this);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new MortarFluidWrapper(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (worldIn.func_180495_p(blockpos).func_177230_c() != Blocks.field_150355_j) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            worldIn.func_184148_a(playerIn, playerIn.field_70165_t, playerIn.field_70163_u + (double)(playerIn.field_70131_O / 2.0f), playerIn.field_70161_v, stack.func_77960_j() == Variant.EMPTY.getMeta() ? SoundEvents.field_187615_H : SoundEvents.field_191241_J, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            stack.func_190918_g(1);
            ItemStack newStack = this.getItemStack(stack.func_77960_j() == Variant.EMPTY.getMeta() ? Variant.WATER : Variant.EMPTY);
            if (stack.func_190926_b()) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)newStack);
            }
            playerIn.func_191521_c(newStack);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ActionResult<ItemStack> actionResult = this.func_77659_a(worldIn, player, hand);
        if (actionResult.func_188397_a() == EnumActionResult.SUCCESS) {
            player.func_184611_a(hand, (ItemStack)actionResult.func_188398_b());
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        int meta = stack.func_77960_j();
        if (meta != Variant.WATER.getMeta()) {
            BlockPos result = PlayerUtil.tryPlaceBlock((World)worldIn, (BlockPos)pos, (EnumFacing)side, (EntityPlayer)player, (EnumHand)hand, (IBlockState)CuisineRegistry.MORTAR.getStateForPlacement(worldIn, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand), (ItemStack)stack, (boolean)false);
            return result != null ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            items.add((Object)new ItemStack((Item)this, 1, 1));
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public static enum Variant implements IVariant<Void>
    {
        EMPTY,
        WATER;


        public int getMeta() {
            return this.ordinal();
        }

        public Void getValue() {
            return null;
        }
    }

    public class MortarFluidWrapper
    implements IFluidHandlerItem,
    ICapabilityProvider {
        protected ItemStack container;

        public MortarFluidWrapper(ItemStack container) {
            this.container = container;
        }

        @Nullable
        public FluidStack getFluid() {
            int meta = this.container.func_77960_j();
            if (meta == Variant.WATER.getMeta()) {
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            return null;
        }

        protected void setFluid(@Nullable FluidStack fluidStack) {
            this.container = this.container.func_77946_l();
            this.container.func_190920_e(1);
            this.container.func_77964_b(fluidStack == null ? Variant.EMPTY.getMeta() : Variant.WATER.getMeta());
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && fluid.getFluid() == FluidRegistry.WATER;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 1000)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null || resource.amount < 1000 || this.getFluid() != null || !this.canFillFluidType(resource)) {
                return 0;
            }
            if (doFill) {
                this.setFluid(resource);
            }
            return 1000;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || this.getFluid() == null || !this.getFluid().isFluidEqual(resource)) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain < 1000 || this.getFluid() == null) {
                return null;
            }
            FluidStack fluidStack = this.getFluid();
            if (doDrain) {
                this.setFluid(null);
            }
            return fluidStack;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this);
            }
            return null;
        }

        public ItemStack getContainer() {
            return this.container;
        }
    }
}

