/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.items;

import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import snownee.cuisine.Cuisine;
import snownee.cuisine.api.CookingStrategy;
import snownee.cuisine.api.CookingStrategyProvider;
import snownee.cuisine.api.CookingVessel;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.IngredientTrait;
import snownee.cuisine.api.Seasoning;
import snownee.cuisine.internal.food.Dish;
import snownee.kiwi.item.ItemMod;

public class ItemIronSpatula
extends ItemMod
implements CookingStrategyProvider {
    public ItemIronSpatula(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77637_a(Cuisine.CREATIVE_TAB);
    }

    @Override
    @Nonnull
    public CookingStrategy getCookingStrategy(ItemStack stack) {
        return new StirFrying();
    }

    static final class StirFrying
    implements CookingStrategy<Dish.Builder> {
        int oilAmount = 0;
        int currentSize = 0;

        StirFrying() {
        }

        @Override
        public void beginCook(Dish.Builder dish) {
            this.currentSize = dish.getIngredients().size();
        }

        @Override
        public void preCook(Seasoning seasoning, CookingVessel vessel) {
            if (seasoning.hasKeyword("oil")) {
                this.oilAmount += seasoning.getSize();
            }
        }

        @Override
        public void cook(Ingredient ingredient, CookingVessel vessel) {
            if (this.oilAmount > 0) {
                ingredient.addTrait(IngredientTrait.AROMATIC);
                if (this.currentSize > 0 && (double)((float)this.oilAmount / (float)this.currentSize) > 0.25) {
                    ingredient.addTrait(IngredientTrait.OILY);
                } else {
                    ingredient.removeTrait(IngredientTrait.OILY);
                }
            }
        }

        @Override
        public void postCook(Dish.Builder dish, CookingVessel vessel) {
            Collections.shuffle(dish.getIngredients(), field_77697_d);
        }

        @Override
        public void endCook() {
        }
    }
}

