/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.items;

import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CookingVessel;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Effect;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.IngredientTrait;
import snownee.cuisine.api.Material;
import snownee.cuisine.client.CuisineItemRendering;
import snownee.cuisine.client.model.IngredientMeshDefinition;
import snownee.cuisine.internal.CuisinePersistenceCenter;
import snownee.cuisine.internal.food.IngredientFood;
import snownee.cuisine.util.I18nUtil;
import snownee.kiwi.client.AdvancedFontRenderer;
import snownee.kiwi.item.IModItem;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.Util;

public final class ItemIngredient
extends ItemFood
implements IModItem,
CookingVessel {
    public static final String KEY_ACTIONS = "actions";

    public ItemIngredient() {
        super(1, false);
    }

    public String getName() {
        return "ingredient";
    }

    public void register(String modid) {
        this.setRegistryName(modid, this.getName());
        this.func_77655_b(modid + "." + this.getName());
    }

    public Item cast() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void mapModel() {
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)IngredientMeshDefinition.INSTANCE);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{CuisineItemRendering.EMPTY_MODEL, new ResourceLocation("cuisine", "cmaterial/cubed"), new ResourceLocation("cuisine", "cmaterial/diced"), new ResourceLocation("cuisine", "cmaterial/minced"), new ResourceLocation("cuisine", "cmaterial/paste"), new ResourceLocation("cuisine", "cmaterial/shredded"), new ResourceLocation("cuisine", "cmaterial/sliced")});
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (stack.func_77978_p() != null && entityLiving instanceof EntityPlayer) {
            Ingredient ingredient;
            EntityPlayer player = (EntityPlayer)entityLiving;
            worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.func_77849_c(stack, worldIn, player);
            player.func_71029_a(StatList.func_188057_b((Item)this));
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, stack);
            }
            if ((ingredient = CuisinePersistenceCenter.deserializeIngredient(stack.func_77978_p())) != null) {
                IngredientFood.Builder builder = new IngredientFood.Builder();
                builder.addIngredient(null, ingredient, this);
                Optional<IngredientFood> result = builder.build(this, null);
                if (result.isPresent()) {
                    result.get().onEaten(stack, worldIn, player);
                }
            }
        }
        stack.func_190918_g(1);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return false;
        }
        Ingredient ingredient = CuisinePersistenceCenter.deserializeIngredient(stack.func_77978_p());
        if (ingredient == null) {
            return false;
        }
        return ingredient.getMaterial().hasGlowingOverlay(ingredient);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        Ingredient ingredient;
        NBTTagCompound data = stack.func_77978_p();
        if (data != null && (ingredient = CuisinePersistenceCenter.deserializeIngredient(data)) != null) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                for (IngredientTrait trait : ingredient.getAllTraits()) {
                    tooltip.add(TextFormatting.ITALIC + I18n.func_135052_a((String)trait.getTranslationKey(), (Object[])new Object[0]));
                }
            } else {
                for (Effect effect : ingredient.getEffects()) {
                    if (!effect.showInTooltips()) continue;
                    tooltip.add(Util.color((int)effect.getColor()) + I18n.func_135052_a((String)effect.getName(), (Object[])new Object[0]));
                }
                tooltip.add(TextFormatting.WHITE + TextFormatting.ITALIC.toString() + I18nUtil.translate("tip.shift_ingredients"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return AdvancedFontRenderer.INSTANCE;
    }

    @Nonnull
    public String func_77653_i(ItemStack stack) {
        NBTTagCompound data = stack.func_77978_p();
        if (data == null) {
            return I18nUtil.translate("material.unknown");
        }
        Ingredient ingredient = CuisinePersistenceCenter.deserializeIngredient(data);
        return ingredient == null ? I18nUtil.translate("material.unknown") : ingredient.getTranslation();
    }

    public final void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    @Override
    public Optional<ItemStack> serve() {
        return Optional.empty();
    }

    public static ItemStack make(Material material, Form form) {
        return ItemIngredient.make(material, form, 1, form.getStandardActions());
    }

    public static ItemStack make(Material material, Form form, int amount, int[] actions) {
        if (material.isValidForm(form)) {
            ItemStack stack = new ItemStack((Item)CuisineRegistry.INGREDIENT, amount);
            Ingredient ingredient = new Ingredient(material, form);
            NBTTagCompound data = CuisinePersistenceCenter.serialize(ingredient);
            data.func_74783_a(KEY_ACTIONS, actions);
            stack.func_77982_d(data);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack make(Ingredient ingredient) {
        ItemStack itemStack = new ItemStack((Item)CuisineRegistry.INGREDIENT);
        itemStack.func_77982_d(CuisinePersistenceCenter.serialize(ingredient));
        if (ingredient.getEffects().contains(CulinaryHub.CommonEffects.RARE)) {
            NBTHelper.of((ItemStack)itemStack).setBoolean("rare", true);
        }
        return itemStack;
    }

    public static int[] getActions(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_150297_b(KEY_ACTIONS, 11)) {
            if (stack.func_77973_b() == CuisineRegistry.INGREDIENT) {
                Cuisine.logger.warn("Found invalid ItemIngredient: {}", (Object)stack);
            }
            return new int[2];
        }
        return tag.func_74759_k(KEY_ACTIONS);
    }

    public static List<ItemStack> getAllValidFormsInRange(Material material, EnumSet<Form> range) {
        Object forms = range.clone();
        ((AbstractCollection)forms).retainAll(material.getValidForms());
        return forms.stream().map(form -> ItemIngredient.make(material, form)).collect(Collectors.toList());
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return NBTHelper.of((ItemStack)stack).getBoolean("rare") ? EnumRarity.UNCOMMON : EnumRarity.COMMON;
    }

    public static List<ItemStack> getAllValidFormsWithException(Material material, EnumSet<Form> exceptions) {
        EnumSet<Form> forms = EnumSet.complementOf(exceptions);
        forms.retainAll(material.getValidForms());
        return forms.stream().map(form -> ItemIngredient.make(material, form)).collect(Collectors.toList());
    }
}

