/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.cuisine.Cuisine;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.FoodContainer;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.events.ConsumeCompositeFoodEvent;
import snownee.cuisine.client.CuisineItemRendering;
import snownee.cuisine.client.model.DishMeshDefinition;
import snownee.cuisine.internal.capabilities.DrinkContainer;
import snownee.cuisine.internal.food.Drink;
import snownee.cuisine.items.ItemAbstractComposite;
import snownee.cuisine.plugins.TANCompat;
import snownee.kiwi.util.NBTHelper;

public class ItemDrink
extends ItemAbstractComposite {
    public ItemDrink(String name) {
        super(name);
        this.func_77637_a(Cuisine.CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void mapModel() {
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)DishMeshDefinition.INSTANCE);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{CuisineItemRendering.EMPTY_MODEL, new ResourceLocation("cuisine", "dish/drink"), new ResourceLocation("cuisine", "dish/smoothie"), new ResourceLocation("cuisine", "dish/gelo"), new ResourceLocation("cuisine", "dish/soda")});
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new DrinkContainer();
    }

    @Override
    @Nonnull
    public String func_77653_i(ItemStack stack) {
        List<Ingredient> ingredients;
        CompositeFood drink;
        String s = NBTHelper.of((ItemStack)stack).getString("customName");
        if (s != null) {
            return s;
        }
        FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container != null && (drink = container.get()) != null && drink.getClass() == Drink.class && (ingredients = drink.getIngredients()).size() == 1) {
            if (((Drink)drink).getDrinkType() == Drink.DrinkType.NORMAL) {
                return ingredients.get(0).getTranslation();
            }
            return I18n.func_135052_a((String)(((Drink)drink).getDrinkType().getTranslationKey() + ".specific"), (Object[])new Object[]{I18n.func_135052_a((String)ingredients.get(0).getMaterial().getTranslationKey(), (Object[])new Object[0])});
        }
        return super.func_77653_i(stack);
    }

    public String func_77667_c(ItemStack stack) {
        CompositeFood drink;
        FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container != null && (drink = container.get()) != null && drink.getClass() == Drink.class) {
            return ((Drink)drink).getDrinkType().getTranslationKey();
        }
        return super.func_77667_c(stack);
    }

    @Override
    public EnumAction func_77661_b(ItemStack stack) {
        CompositeFood drink;
        FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container != null && (drink = container.get()) != null && drink.getClass() == Drink.class && ((Drink)drink).getDrinkType() == Drink.DrinkType.SMOOTHIE) {
            return EnumAction.EAT;
        }
        return EnumAction.DRINK;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        CompositeFood drink;
        if (!Drink.enableThirst()) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        ItemStack stack = playerIn.func_184586_b(handIn);
        FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container == null || (drink = container.get()) == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)ItemStack.field_190927_a);
        }
        if (drink.alwaysEdible() || TANCompat.isPlayerThirsty(playerIn)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @Override
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            FoodContainer foodContainer = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
            if (foodContainer == null) {
                return stack;
            }
            CompositeFood drink = foodContainer.get();
            if (drink == null) {
                stack.func_190920_e(0);
                return stack;
            }
            ConsumeCompositeFoodEvent.Pre pre = new ConsumeCompositeFoodEvent.Pre(drink, player, null);
            if (!MinecraftForge.EVENT_BUS.post((Event)pre) && pre.getResult() != Event.Result.DENY) {
                if (!player.func_184812_l_()) {
                    drink.setServes(drink.getServes() - 1);
                }
                drink.onEaten(stack, worldIn, player);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                ConsumeCompositeFoodEvent.Post post = new ConsumeCompositeFoodEvent.Post(drink, player, null);
                MinecraftForge.EVENT_BUS.post((Event)post);
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, stack);
                }
                if (drink.getServes() < 1) {
                    return foodContainer.getEmptyContainer(stack);
                }
            }
        }
        return stack;
    }
}

