/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.items;

import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.items.IRarityGetter;
import snownee.cuisine.items.ItemBasicFood;
import snownee.cuisine.library.RarityManager;
import snownee.cuisine.util.I18nUtil;
import snownee.kiwi.item.IVariant;
import snownee.kiwi.util.PlayerUtil;

public class ItemCrops
extends ItemBasicFood<SubCrop, Variant> {
    public ItemCrops(String name) {
        super(name, (IVariant[])Variant.values());
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        Variant variant = (Variant)this.getVariants().get(stack.func_77960_j());
        BlockPos target = this.canPlantAt(worldIn, pos, facing, variant, player);
        if (target != null) {
            IGrowable igrowable;
            IBlockState iblockstate;
            IBlockState newState = variant.subCrop.getBlock().getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
            EnumRarity rarity = RarityManager.getRarity(stack);
            boolean flag = PlayerUtil.tryPlaceBlock((World)worldIn, (BlockPos)target, (EnumFacing)facing, (EntityPlayer)player, (EnumHand)hand, (IBlockState)newState, (ItemStack)stack);
            if (flag && rarity != EnumRarity.COMMON && (iblockstate = worldIn.func_180495_p(target)).func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)iblockstate.func_177230_c()).func_176473_a(worldIn, target, iblockstate, worldIn.field_72995_K) && !worldIn.field_72995_K) {
                worldIn.func_175718_b(2005, target, 0);
                if (igrowable.func_180670_a(worldIn, worldIn.field_73012_v, target, iblockstate)) {
                    igrowable.func_176474_b(worldIn, worldIn.field_73012_v, target, iblockstate);
                }
            }
            return flag ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    @Nullable
    public BlockPos canPlantAt(World world, BlockPos pos, EnumFacing side, Variant variant, EntityPlayer player) {
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        if (variant.subCrop.getBlock() == null) {
            Cuisine.logger.error("{}: Attempting plant a crop which doesnt have a block!", (Object)variant.getName());
            return null;
        }
        if (!(world.func_175660_a(player, pos) && world.func_190527_a(variant.subCrop.getBlock(), pos, true, side, (Entity)player) && player.field_71075_bZ.field_75099_e)) {
            return null;
        }
        if (variant.subCrop.getPlantType() == EnumPlantType.Water) {
            IBlockState soilState = world.func_180495_p(pos.func_177977_b());
            if (soilState.func_185904_a() != Material.field_151578_c && soilState.func_185904_a() != Material.field_151577_b) {
                return null;
            }
            IBlockState waterState = world.func_180495_p(pos);
            if (waterState.func_177230_c() != Blocks.field_150355_j) {
                return null;
            }
            if (waterState.func_177227_a().contains(BlockLiquid.field_176367_b) && (Integer)waterState.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                return null;
            }
            IBlockState oldState = world.func_180495_p(pos.func_177984_a());
            return oldState.func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a()) ? pos.func_177984_a() : null;
        }
        if (!(variant.subCrop.getBlock() instanceof IPlantable)) {
            return null;
        }
        IBlockState soilState = world.func_180495_p(pos.func_177977_b());
        return soilState.func_177230_c().canSustainPlant(soilState, (IBlockAccess)world, pos.func_177977_b(), side, (IPlantable)variant.subCrop.getBlock()) ? pos : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        SubCrop subCrop = ((Variant)this.getVariants().get(stack.func_77960_j())).subCrop;
        if (subCrop.getPlantType() != EnumPlantType.Crop) {
            tooltip.add(I18nUtil.translate("tip.crops." + subCrop.getPlantType().toString().toLowerCase(Locale.ROOT)));
        }
    }

    public static class SubCrop {
        private final EnumPlantType plantType;
        private final Supplier<Block> block;

        protected SubCrop(Supplier<Block> block, EnumPlantType plantType) {
            this.block = block;
            this.plantType = plantType;
        }

        public EnumPlantType getPlantType() {
            return this.plantType;
        }

        public Block getBlock() {
            return this.block.get();
        }
    }

    public static enum Variant implements IVariant<SubCrop>,
    IRarityGetter
    {
        PEANUT(() -> CuisineRegistry.PEANUT),
        SESAME(() -> CuisineRegistry.SESAME),
        SOYBEAN(() -> CuisineRegistry.SOYBEAN),
        RICE(() -> CuisineRegistry.RICE, EnumPlantType.Water),
        TOMATO(() -> CuisineRegistry.TOMATO),
        CHILI(() -> CuisineRegistry.CHILI, EnumPlantType.Nether),
        GARLIC(() -> CuisineRegistry.GARLIC),
        GINGER(() -> CuisineRegistry.GINGER),
        SICHUAN_PEPPER(() -> CuisineRegistry.SICHUAN_PEPPER),
        SCALLION(() -> CuisineRegistry.SCALLION),
        TURNIP(() -> CuisineRegistry.TURNIP),
        CHINESE_CABBAGE(() -> CuisineRegistry.CHINESE_CABBAGE),
        LETTUCE(() -> CuisineRegistry.LETTUCE),
        CORN(() -> CuisineRegistry.CORN),
        CUCUMBER(() -> CuisineRegistry.CUCUMBER),
        GREEN_PEPPER(() -> CuisineRegistry.GREEN_PEPPER),
        RED_PEPPER(() -> CuisineRegistry.RED_PEPPER),
        LEEK(() -> CuisineRegistry.LEEK),
        ONION(() -> CuisineRegistry.ONION),
        EGGPLANT(() -> CuisineRegistry.EGGPLANT),
        SPINACH(() -> CuisineRegistry.SPINACH),
        BAMBOO_SHOOT(() -> CuisineRegistry.BAMBOO_PLANT, EnumPlantType.Plains);

        private final SubCrop subCrop;

        private Variant(Supplier<Block> block) {
            this(block, EnumPlantType.Crop);
        }

        private Variant(Supplier<Block> block, EnumPlantType plantType) {
            this.subCrop = new SubCrop(block, plantType);
        }

        @Override
        public EnumRarity getRarity() {
            return EnumRarity.COMMON;
        }

        public int getMeta() {
            return this.ordinal();
        }

        public SubCrop getValue() {
            return this.subCrop;
        }
    }
}

