/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.items;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CookingVessel;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.Material;
import snownee.cuisine.crafting.DrinkBrewingRecipe;
import snownee.cuisine.internal.capabilities.GlassBottleHandler;
import snownee.cuisine.internal.food.Drink;
import snownee.cuisine.util.I18nUtil;
import snownee.kiwi.item.ItemMod;
import snownee.kiwi.util.NBTHelper;

public class ItemBottle
extends ItemMod
implements CookingVessel {
    public ItemBottle(String name) {
        super(name);
        this.func_77642_a(Items.field_151069_bo);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (NBTHelper.of((ItemStack)stack).hasTag("potion", 8)) {
            PotionUtils.func_185182_a((ItemStack)DrinkBrewingRecipe.makeDummyPotionItem(stack), tooltip, (float)CuisineConfig.GENERAL.winePotionDurationModifier);
            String id = ItemBottle.getMaterial(stack);
            if ("corn".equals(id)) {
                tooltip.add(I18nUtil.translate("bourbon"));
            } else if ("orange".equals(id) || "lime".equals(id) || "mandarin".equals(id)) {
                tooltip.add(I18nUtil.translate("curasao"));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        NBTHelper helper = NBTHelper.of((ItemStack)stack);
        if (helper.hasTag("liquidColor", 3)) {
            return false;
        }
        return super.func_77636_d(stack) || helper.hasTag("potion", 8);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new GlassBottleHandler.GlassBottleWrapper(stack);
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluid;
        if (NBTHelper.of((ItemStack)stack).hasTag("potion", 8)) {
            Material material;
            String id = ItemBottle.getMaterial(stack);
            if (id != null && (material = CulinaryHub.API_INSTANCE.findMaterial(id)) != null) {
                return I18nUtil.translate("wine.specific", I18n.func_135052_a((String)material.getTranslationKey(), (Object[])new Object[0]));
            }
            return I18nUtil.translate("wine.name");
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)(stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1)));
        if (handler != null && (fluid = handler.drain(Integer.MAX_VALUE, false)) != null) {
            return Cuisine.sidedDelegate.translate(this.func_77667_c(stack) + ".name", fluid.getLocalizedName());
        }
        return super.func_77653_i(stack);
    }

    @Nullable
    private static String getMaterial(ItemStack stack) {
        return NBTHelper.of((ItemStack)stack).getString("Fluid.Tag.material");
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return stack;
        }
        EntityPlayer entityplayer = (EntityPlayer)entityLiving;
        String id = NBTHelper.of((ItemStack)stack).getString("Fluid.Tag.material", "");
        Material material = CulinaryHub.API_INSTANCE.findMaterial(id);
        if (material == null || !material.isValidForm(Form.JUICE)) {
            return stack;
        }
        Drink.Builder builder = Drink.Builder.create();
        builder.addIngredient(entityplayer, new Ingredient(material, Form.JUICE), this);
        Optional<Drink> result = builder.build(this, entityplayer);
        if (!result.isPresent()) {
            return stack;
        }
        result.get().onEaten(stack, worldIn, entityplayer);
        if (!worldIn.field_72995_K) {
            ItemStack dummy = DrinkBrewingRecipe.makeDummyPotionItem(stack);
            int duration = 0;
            for (PotionEffect potioneffect : PotionUtils.func_185189_a((ItemStack)dummy)) {
                PotionEffect effect = new PotionEffect(potioneffect.func_188419_a(), (int)((float)potioneffect.func_76459_b() * CuisineConfig.GENERAL.winePotionDurationModifier), potioneffect.func_76458_c(), potioneffect.func_82720_e(), potioneffect.func_188418_e());
                duration += effect.func_76459_b();
                if (effect.func_188419_a().func_76403_b()) {
                    effect.func_188419_a().func_180793_a((Entity)entityplayer, (Entity)entityplayer, entityLiving, potioneffect.func_76458_c(), (double)CuisineConfig.GENERAL.winePotionDurationModifier);
                    continue;
                }
                entityLiving.func_70690_d(effect);
            }
            if (duration > 0) {
                int amplifier = 0;
                PotionEffect potionEffect = entityLiving.func_70660_b((Potion)CuisineRegistry.DRUNK);
                if (potionEffect != null) {
                    duration += potionEffect.func_76459_b();
                    amplifier = potionEffect.func_76458_c() + 1;
                    if (amplifier > 2) {
                        amplifier = 2;
                    }
                }
                entityLiving.func_70690_d(new PotionEffect((Potion)CuisineRegistry.DRUNK, duration, amplifier, true, true));
            }
        }
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        if (entityplayer instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)entityplayer, stack);
        }
        entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            if (stack.func_190926_b()) {
                return new ItemStack(Items.field_151069_bo);
            }
            entityplayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
        }
        return stack;
    }

    @Override
    public Optional<ItemStack> serve() {
        return Optional.empty();
    }
}

