/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.items;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.items.IRarityGetter;
import snownee.cuisine.util.I18nUtil;
import snownee.kiwi.client.ModelUtil;
import snownee.kiwi.item.IModItem;
import snownee.kiwi.item.IVariant;

public class ItemBasicFood<T, E extends IVariant<T> & IRarityGetter>
extends ItemFood
implements IModItem {
    private final String name;
    private final E[] values;
    private static int forestbatLastWords;

    public ItemBasicFood(String name, E[] values) {
        super(1, false);
        this.name = name;
        this.values = values;
        this.func_77637_a(Cuisine.CREATIVE_TAB);
        this.func_77627_a(true);
    }

    public String getName() {
        return this.name;
    }

    public void register(String modid) {
        this.setRegistryName(modid, this.name);
        this.func_77655_b(modid + ".food");
    }

    public Item cast() {
        return this;
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_77960_j() < this.values.length) {
            return ((IRarityGetter)((IVariant)this.getVariants().get(stack.func_77960_j()))).getRarity();
        }
        return super.func_77613_e(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            this.getVariants().stream().filter(v -> v != Variant.EMPOWERED_CITRON).map(x$0 -> this.getItemStack((IVariant)x$0)).forEach(arg_0 -> items.add(arg_0));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77973_b() == CuisineRegistry.BASIC_FOOD && stack.func_77960_j() == Variant.EMPOWERED_CITRON.getMeta();
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        if (stack.func_77973_b() == CuisineRegistry.BASIC_FOOD && stack.func_77960_j() == Variant.EMPOWERED_CITRON.getMeta()) {
            if (player.field_70170_p.field_73012_v.nextInt(4) == 0) {
                ItemBasicFood.citronSays((EntityLivingBase)player, "drop_success");
            } else {
                ItemBasicFood.citronSays((EntityLivingBase)player, "drop_failure");
                return false;
            }
        }
        return true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (stack.func_77973_b() == CuisineRegistry.BASIC_FOOD && stack.func_77960_j() == Variant.EMPOWERED_CITRON.getMeta() && attacker.field_70170_p.field_73012_v.nextInt(5) == 0) {
            ItemBasicFood.citronSays(attacker, "hit");
        }
        return false;
    }

    public static void citronSays(EntityLivingBase player, String key) {
        if (player instanceof FakePlayer || player.field_70170_p.field_72995_K) {
            return;
        }
        int hash = key.hashCode();
        if (hash == forestbatLastWords) {
            return;
        }
        forestbatLastWords = hash;
        key = "forestbat." + key;
        if (I18nUtil.canTranslate(key)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(I18nUtil.getFullKey(key), new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void mapModel() {
        ModelUtil.mapItemVariantsModelNew((Item)this, (String)"food_", this.values, (String)"");
    }

    public List<E> getVariants() {
        return Arrays.asList(this.values);
    }

    public ItemStack getItemStack(E variant) {
        return this.getItemStack(variant, 1);
    }

    public ItemStack getItemStack(E variant, int amount) {
        return new ItemStack((Item)this, amount, variant.getMeta());
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() < this.values.length) {
            return super.func_77667_c(stack) + "." + this.values[stack.func_77960_j()].getName();
        }
        return super.func_77667_c(stack);
    }

    public static enum Variant implements IVariant<Void>,
    IRarityGetter
    {
        TOFU,
        FLOUR,
        DOUGH,
        RICE_POWDER,
        WHITE_RICE,
        PICKLED_CABBAGE,
        PICKLED_CUCUMBER,
        PICKLED_PEPPER,
        PICKLED_TURNIP,
        MANDARIN,
        CITRON,
        POMELO,
        ORANGE,
        LEMON,
        GRAPEFRUIT,
        LIME,
        EMPOWERED_CITRON(EnumRarity.RARE);

        private final EnumRarity rarity;

        private Variant() {
            this(EnumRarity.COMMON);
        }

        private Variant(EnumRarity rarity) {
            this.rarity = rarity;
        }

        public int getMeta() {
            return this.ordinal();
        }

        @Override
        public EnumRarity getRarity() {
            return this.rarity;
        }

        public Void getValue() {
            return null;
        }
    }
}

