/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.items;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Effect;
import snownee.cuisine.api.FoodContainer;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.IngredientTrait;
import snownee.cuisine.api.Seasoning;
import snownee.cuisine.api.events.ConsumeCompositeFoodEvent;
import snownee.cuisine.internal.food.Dish;
import snownee.cuisine.util.I18nUtil;
import snownee.kiwi.client.AdvancedFontRenderer;
import snownee.kiwi.item.ItemMod;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.Util;

public abstract class ItemAbstractComposite
extends ItemMod {
    public ItemAbstractComposite(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @Nonnull
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            FoodContainer foodContainer = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
            if (foodContainer == null) {
                return stack;
            }
            CompositeFood dish = foodContainer.get();
            if (dish == null) {
                stack.func_190920_e(0);
                return stack;
            }
            ConsumeCompositeFoodEvent.Pre pre = new ConsumeCompositeFoodEvent.Pre(dish, player, null);
            if (!MinecraftForge.EVENT_BUS.post((Event)pre) && pre.getResult() != Event.Result.DENY) {
                if (!player.func_184812_l_()) {
                    dish.setServes(dish.getServes() - 1);
                }
                worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
                dish.onEaten(stack, worldIn, player);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                ConsumeCompositeFoodEvent.Post post = new ConsumeCompositeFoodEvent.Post(dish, player, null);
                MinecraftForge.EVENT_BUS.post((Event)post);
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, stack);
                }
                if (dish.getServes() < 1) {
                    return foodContainer.getEmptyContainer(stack);
                }
            } else {
                return stack;
            }
        }
        return stack;
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        CompositeFood food;
        FoodContainer foodContainer;
        NBTTagCompound data = new NBTTagCompound();
        if (stack.func_77978_p() != null) {
            data.func_74782_a("default", (NBTBase)stack.func_77978_p());
        }
        if ((foodContainer = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null)) != null && (food = foodContainer.get()) != null) {
            data.func_74782_a("dish", (NBTBase)CulinaryHub.API_INSTANCE.serialize(food));
        }
        return data;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        FoodContainer foodContainer;
        if (nbt == null) {
            return;
        }
        if (nbt.func_150297_b("dish", 10) && (foodContainer = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null)) != null) {
            NBTTagCompound data = nbt.func_74775_l("dish");
            ResourceLocation id = new ResourceLocation(data.func_74779_i("FoodType"));
            foodContainer.set((CompositeFood)CulinaryHub.API_INSTANCE.deserialize(id, data));
            if (foodContainer.get() == null) {
                foodContainer.set(Dish.deserialize(data));
            }
        }
        if (nbt.func_74764_b("default")) {
            super.readNBTShareTag(stack, nbt.func_74775_l("default"));
        }
    }

    @Nonnull
    public String func_77653_i(ItemStack stack) {
        String s = NBTHelper.of((ItemStack)stack).getString("customName", "");
        return s.isEmpty() ? super.func_77653_i(stack) : s;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        CompositeFood dish;
        FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container == null || (dish = container.get()) == null) {
            if (!stack.func_77942_o() || !stack.func_77978_p().func_150297_b("model", 8)) {
                tooltip.add(I18nUtil.translate("tip.empty_dish"));
            }
            return;
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            List<Seasoning> seasonings;
            List<Ingredient> ingredients = dish.getIngredients();
            if (!ingredients.isEmpty()) {
                tooltip.add(I18nUtil.translate("tip.ingredients"));
                for (Ingredient ingredient : ingredients) {
                    StringBuilder line = new StringBuilder("  " + ingredient.getTranslation());
                    Set<IngredientTrait> characteristics = ingredient.getAllTraits();
                    if (!characteristics.isEmpty()) {
                        line.append(" ").append(TextFormatting.ITALIC);
                    }
                    for (IngredientTrait characteristic : characteristics) {
                        line.append(" ").append(I18n.func_135052_a((String)characteristic.getTranslationKey(), (Object[])new Object[0]));
                    }
                    tooltip.add(line.toString());
                }
            }
            if (!(seasonings = dish.getSeasonings()).isEmpty()) {
                if (!ingredients.isEmpty()) {
                    tooltip.add("");
                }
                tooltip.add(I18nUtil.translate("tip.seasonings"));
                for (Seasoning seasoning : seasonings) {
                    tooltip.add("  " + I18n.func_135052_a((String)seasoning.getSpice().getTranslationKey(), (Object[])new Object[0]) + " * " + seasoning.getSize());
                }
            }
        } else {
            String key = "tip." + (dish.getKeywords().contains("drink") ? "drink" : "food") + "_serve_amount";
            tooltip.add(I18nUtil.translateWithFormat(key, dish.getServes()));
            for (Effect effect : dish.getMergedEffects()) {
                if (!effect.showInTooltips()) continue;
                tooltip.add(Util.color((int)effect.getColor()) + I18n.func_135052_a((String)effect.getName(), (Object[])new Object[0]));
            }
            tooltip.add(TextFormatting.WHITE + TextFormatting.ITALIC.toString() + I18nUtil.translate("tip.shift_ingredients"));
            if (flagIn.func_194127_a() && Minecraft.func_71410_x().field_71474_y.field_74330_P) {
                tooltip.add(I18nUtil.translate("tip.food.hunger_regen", dish.getFoodLevel()));
                tooltip.add(I18nUtil.translateWithFormat("tip.food.saturation", Float.valueOf(dish.getSaturationModifier())));
            }
        }
    }

    public final void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack stack) {
        return stack.hasCapability(CulinaryCapabilities.FOOD_CONTAINER, null) && ((FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null)).get() != null && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
    }

    @SideOnly(value=Side.CLIENT)
    public double getDurabilityForDisplay(ItemStack stack) {
        FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container == null) {
            return 0.0;
        }
        CompositeFood dish = container.get();
        if (dish != null) {
            return MathHelper.func_151237_a((double)(1.0 - (double)dish.getServes() / (double)dish.getMaxServes()), (double)0.0, (double)1.0);
        }
        return 0.0;
    }

    public int func_77626_a(ItemStack stack) {
        CompositeFood dish;
        FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container != null && (dish = container.get()) != null) {
            return Math.max((int)((float)this.getDefaultItemUseDuration() * dish.getUseDurationModifier()), 1);
        }
        return 0;
    }

    protected int getDefaultItemUseDuration() {
        return 32;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.EAT;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        CompositeFood dish;
        ItemStack stack = playerIn.func_184586_b(handIn);
        FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container == null || (dish = container.get()) == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)ItemStack.field_190927_a);
        }
        if (playerIn.func_184812_l_() || playerIn.func_71043_e(dish.alwaysEdible())) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return AdvancedFontRenderer.INSTANCE;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container != null) {
            return container.getEmptyContainer(stack);
        }
        return ItemStack.field_190927_a;
    }
}

