/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.internal.food;

import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.CookingStrategy;
import snownee.cuisine.api.CookingVessel;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.IngredientTrait;
import snownee.cuisine.api.Seasoning;

public class FoodValueCounter
implements CookingStrategy {
    private float hungerRegen;
    private float saturation;

    public FoodValueCounter() {
        this(0.0f, 0.0f);
    }

    public FoodValueCounter(float initialHungerRegen, float initialSaturation) {
        this.hungerRegen = initialHungerRegen;
        this.saturation = initialSaturation;
    }

    public void beginCook(CompositeFood.Builder dish) {
    }

    @Override
    public void preCook(Seasoning seasoning, CookingVessel vessel) {
    }

    @Override
    public void cook(Ingredient ingredient, CookingVessel vessel) {
        this.saturation += ingredient.getSaturationModifier();
        if (ingredient.hasTrait(IngredientTrait.PLAIN) || ingredient.hasTrait(IngredientTrait.OVERCOOKED)) {
            this.saturation = (float)((double)this.saturation - 0.1);
        }
        this.hungerRegen = (float)((double)this.hungerRegen + ingredient.getFoodLevel() * (ingredient.hasTrait(IngredientTrait.PLAIN) ? 0.5 : 1.0));
    }

    public void postCook(CompositeFood.Builder dish, CookingVessel vessel) {
    }

    @Override
    public void endCook() {
    }

    public int getHungerRegen() {
        return (int)Math.ceil(this.hungerRegen);
    }

    public float getSaturation() {
        return Math.max(this.saturation, 0.0f);
    }
}

