/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.internal.food;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.CookingVessel;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Effect;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.IngredientTrait;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.MaterialCategory;
import snownee.cuisine.api.Seasoning;
import snownee.cuisine.api.prefab.DefaultConsumedCollector;
import snownee.cuisine.api.prefab.DefaultTypes;
import snownee.cuisine.internal.CuisinePersistenceCenter;
import snownee.cuisine.internal.effect.EffectPotions;
import snownee.cuisine.internal.food.FoodValueCounter;
import snownee.cuisine.plugins.TANCompat;
import snownee.kiwi.Kiwi;
import snownee.kiwi.crafting.input.ProcessingInput;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.definition.ItemDefinition;
import snownee.kiwi.util.definition.OreDictDefinition;

public class Drink
extends CompositeFood {
    public static final ResourceLocation DRINK_ID = new ResourceLocation("cuisine", "drink");
    private DrinkType drinkType;
    private final int color;

    protected Drink(List<Ingredient> ingredients, List<Seasoning> seasonings, List<Effect> effects, int foodLevel, float saturation, DrinkType drinkType, int color) {
        super(ingredients, seasonings, effects, foodLevel, saturation, 2);
        this.drinkType = drinkType;
        this.color = color;
    }

    @Override
    public ResourceLocation getIdentifier() {
        return DRINK_ID;
    }

    @Override
    public ItemStack getBaseItem() {
        return new ItemStack((Item)CuisineRegistry.DRINK);
    }

    @Override
    public String getOrComputeModelType() {
        return this.drinkType.getName();
    }

    public DrinkType getDrinkType() {
        return this.drinkType;
    }

    @Override
    public void setModelType(String type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> getKeywords() {
        return Collections.singletonList("drink");
    }

    public static final boolean enableThirst() {
        return Kiwi.isLoaded((ResourceLocation)new ResourceLocation("cuisine", "toughasnails")) && TANCompat.enableThirst();
    }

    @Override
    public void onEaten(ItemStack stack, World worldIn, EntityPlayer player) {
        Collection<CompositeFood.EffectBinding> bindings = this.getEffectBindings();
        float modifier = 1.0f;
        for (Object seasoning : this.seasonings) {
            if (((Seasoning)seasoning).getSpice() == CulinaryHub.CommonSpices.UNREFINED_SUGAR) {
                modifier = (float)((double)modifier + (double)((Seasoning)seasoning).getSize() * 0.1);
                continue;
            }
            if (((Seasoning)seasoning).getSpice() == CulinaryHub.CommonSpices.SUGAR) {
                modifier = (float)((double)modifier + (double)((Seasoning)seasoning).getSize() * 0.2);
                continue;
            }
            if (((Seasoning)seasoning).getSpice() == CulinaryHub.CommonSpices.SALT) {
                modifier = (float)((double)modifier - (double)((Seasoning)seasoning).getSize() * 0.1);
                continue;
            }
            if (((Seasoning)seasoning).getSpice() == CulinaryHub.CommonSpices.CRUDE_SALT) {
                modifier = (float)((double)modifier - (double)((Seasoning)seasoning).getSize() * 0.2);
                continue;
            }
            if (!CuisineConfig.HARDCORE.enable || !CuisineConfig.HARDCORE.badSkillPunishment || ((Seasoning)seasoning).getSpice() != CulinaryHub.CommonSpices.SOY_SAUCE && ((Seasoning)seasoning).getSpice() != CulinaryHub.CommonSpices.CHILI_POWDER && ((Seasoning)seasoning).getSpice() != CulinaryHub.CommonSpices.SICHUAN_PEPPER_POWDER) continue;
            modifier = 0.0f;
            break;
        }
        DefaultConsumedCollector collector = new DefaultConsumedCollector(this.getFoodLevel(), modifier);
        for (CompositeFood.EffectBinding binding : bindings) {
            binding.effect.onEaten(stack, player, this, binding.ingredients, collector);
        }
        for (Seasoning seasoning : this.seasonings) {
            seasoning.getSpice().onConsumed(stack, player, worldIn, seasoning, collector);
        }
        if (this.getFoodLevel() <= 0) {
            return;
        }
        if (!Drink.enableThirst()) {
            player.func_71024_bL().func_75122_a(1, this.getSaturationModifier());
        }
        if (!worldIn.field_72995_K) {
            double vege = 0.0;
            double fruit = 0.0;
            double others = 0.0;
            for (Ingredient ingredient : this.getIngredients()) {
                if (this.getEffects().stream().anyMatch(e -> e instanceof EffectPotions)) continue;
                Material material = ingredient.getMaterial();
                if (material.isUnderCategoryOf(MaterialCategory.VEGETABLES)) {
                    vege += 1.0;
                }
                if (material.isUnderCategoryOf(MaterialCategory.FRUIT)) {
                    fruit += 1.0;
                }
                if (material.isUnderCategoryOf(MaterialCategory.VEGETABLES) || material.isUnderCategoryOf(MaterialCategory.FRUIT)) continue;
                others += 1.0;
            }
            if (vege != 0.0 || fruit != 0.0) {
                Potion potion;
                boolean flag = vege == fruit ? new Random().nextBoolean() : vege > fruit;
                int duration = (int)(Math.log(1.5 + (flag ? vege : fruit) * 1.5 + (flag ? fruit : vege) * 0.6 + others * 0.3) * 1000.0);
                if (this.getIngredients().size() < 2) {
                    duration = (int)((double)duration * 0.8);
                }
                Potion potion2 = potion = flag ? this.drinkType.getPotionVege() : this.drinkType.getPotionFruit();
                if (potion == null) {
                    potion = MobEffects.field_76424_c;
                }
                collector.addEffect(DefaultTypes.POTION, new PotionEffect(potion, duration, 0, true, true));
            }
            if (modifier <= 0.1f) {
                player.func_70690_d(new PotionEffect(worldIn.field_73012_v.nextBoolean() ? MobEffects.field_76421_d : MobEffects.field_76419_f, 1200));
            } else if (modifier > 0.25f) {
                collector.apply(this, player);
            }
            PotionEffect effect = player.func_70660_b((Potion)CuisineRegistry.EFFECT_RESISTANCE);
            if (effect != null) {
                player.func_184589_d((Potion)CuisineRegistry.EFFECT_RESISTANCE);
                player.func_70690_d(new PotionEffect((Potion)CuisineRegistry.EFFECT_RESISTANCE, (int)((double)effect.func_76459_b() * 0.25), effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
            }
        }
        if (this.drinkType == DrinkType.SMOOTHIE) {
            player.func_70066_B();
        }
    }

    public static NBTTagCompound serialize(Drink drink) {
        NBTTagCompound data = new NBTTagCompound();
        NBTTagList ingredientList = new NBTTagList();
        for (Object ingredient : drink.ingredients) {
            ingredientList.func_74742_a((NBTBase)CuisinePersistenceCenter.serialize((Ingredient)ingredient));
        }
        data.func_74782_a("ingredients", (NBTBase)ingredientList);
        NBTTagList seasoningList = new NBTTagList();
        for (Seasoning seasoning : drink.seasonings) {
            seasoningList.func_74742_a((NBTBase)CuisinePersistenceCenter.serialize(seasoning));
        }
        data.func_74782_a("seasonings", (NBTBase)seasoningList);
        NBTTagList effectList = new NBTTagList();
        for (Effect effect : drink.effects) {
            effectList.func_74742_a((NBTBase)new NBTTagString(effect.getID()));
        }
        data.func_74782_a("effects", (NBTBase)effectList);
        data.func_74778_a("type", drink.getDrinkType().getName());
        data.func_74768_a("color", drink.getColor());
        data.func_74768_a("foodLevel", drink.getFoodLevel());
        data.func_74776_a("saturation", drink.getSaturationModifier());
        data.func_74768_a("durability", drink.getServes());
        data.func_74776_a("useDuration", drink.getUseDurationModifier());
        return data;
    }

    public static Drink deserialize(NBTTagCompound data) {
        NBTHelper helper = NBTHelper.of((NBTTagCompound)data);
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        ArrayList<Seasoning> seasonings = new ArrayList<Seasoning>();
        ArrayList<Effect> effects = new ArrayList<Effect>();
        NBTTagList ingredientList = data.func_150295_c("ingredients", 10);
        for (Object baseTag : ingredientList) {
            if (baseTag.func_74732_a() != 10) continue;
            ingredients.add(CuisinePersistenceCenter.deserializeIngredient((NBTTagCompound)baseTag));
        }
        NBTTagList seasoningList = data.func_150295_c("seasonings", 10);
        for (Object baseTag : seasoningList) {
            if (baseTag.func_74732_a() != 10) continue;
            seasonings.add(CuisinePersistenceCenter.deserializeSeasoning((NBTTagCompound)baseTag));
        }
        NBTTagList effectList = data.func_150295_c("effects", 8);
        for (NBTBase baseTag : effectList) {
            if (baseTag.func_74732_a() != 8) continue;
            effects.add(CulinaryHub.API_INSTANCE.findEffect(((NBTTagString)baseTag).func_150285_a_()));
        }
        int serves = helper.getInt("durability");
        float duration = helper.getFloat("useDuration", 1.0f);
        int foodLevel = helper.getInt("foodLevel");
        float saturation = helper.getFloat("saturation");
        DrinkType drinkType = DrinkType.get(helper.getString("type", "normal"));
        if (drinkType == null) {
            drinkType = DrinkType.NORMAL;
        }
        int color = helper.getInt("color", -1);
        Drink drink = new Drink(ingredients, seasonings, effects, foodLevel, saturation, drinkType, color);
        drink.setServes(serves);
        drink.setUseDurationModifier(duration);
        return drink;
    }

    public int getColor() {
        return this.color;
    }

    public static class DrinkType {
        public static final Map<String, DrinkType> DRINK_TYPES = new HashMap<String, DrinkType>(8);
        public static final DrinkType NORMAL = new DrinkType("drink", ItemDefinition.of((Item)Items.field_151069_bo), MobEffects.field_76430_j, MobEffects.field_76424_c);
        public static final DrinkType SMOOTHIE = new DrinkType("smoothie", ItemDefinition.of((Block)CuisineRegistry.PLACED_DISH), (Potion)CuisineRegistry.TOUGHNESS, MobEffects.field_76429_m);
        public static final DrinkType GELO = new DrinkType("gelo", ItemDefinition.EMPTY, MobEffects.field_76430_j, MobEffects.field_76424_c);
        public static final DrinkType SODA = new DrinkType("soda", ItemDefinition.of((Item)Items.field_151069_bo), (Potion)CuisineRegistry.COLD_BLOOD, MobEffects.field_76420_g);
        private final ProcessingInput containerPre;
        private final ItemDefinition containerPost;
        private final String name;
        private final Potion potionVege;
        private final Potion potionFruit;

        public static DrinkType get(String name) {
            return DRINK_TYPES.get(name);
        }

        public DrinkType(String name, ItemDefinition container, Potion potionVege, Potion potionFruit) {
            this(name, (ProcessingInput)container, container, potionVege, potionFruit);
            DRINK_TYPES.put(name, this);
        }

        public DrinkType(String name, ProcessingInput containerPre, ItemDefinition containerPost, Potion potionVege, Potion potionFruit) {
            this.name = name;
            this.containerPre = containerPre;
            this.containerPost = containerPost;
            this.potionVege = potionVege;
            this.potionFruit = potionFruit;
        }

        public String getName() {
            return this.name;
        }

        public String getTranslationKey() {
            Calendar calendar;
            if (this == SMOOTHIE && (calendar = Calendar.getInstance()).get(2) == 4 && calendar.get(5) == 18) {
                return "cuisine.snownee";
            }
            return "cuisine." + this.name;
        }

        public ProcessingInput getContainerPre() {
            return this.containerPre;
        }

        public ItemStack getContainerPost() {
            return this.containerPost.getItemStack();
        }

        public Potion getPotionVege() {
            return this.potionVege;
        }

        public Potion getPotionFruit() {
            return this.potionFruit;
        }
    }

    public static final class Builder
    extends CompositeFood.Builder<Drink> {
        public Drink completed;
        public DrinkType drinkType = DrinkType.NORMAL;
        private int color = -1;
        public static final Map<ProcessingInput, DrinkType> FEATURE_INPUTS = new HashMap<ProcessingInput, DrinkType>(4);

        Builder(List<Ingredient> ingredients, List<Seasoning> seasonings, List<Effect> effects) {
            super(ingredients, seasonings, effects);
        }

        private Builder() {
            this(new ArrayList<Ingredient>(), new ArrayList<Seasoning>(), new ArrayList<Effect>());
        }

        public static Builder create() {
            return new Builder();
        }

        public static boolean isFeatureItem(ItemStack item) {
            return FEATURE_INPUTS.keySet().stream().anyMatch(i -> i.matches(item));
        }

        public static boolean isContainerItem(ItemStack item) {
            return FEATURE_INPUTS.values().stream().anyMatch(i -> i.getContainerPre().matches(item));
        }

        public static DrinkType findDrinkType(ItemStack item) {
            if (!item.func_190926_b()) {
                for (Map.Entry<ProcessingInput, DrinkType> entry : FEATURE_INPUTS.entrySet()) {
                    if (!entry.getKey().matches(item)) continue;
                    return entry.getValue();
                }
            }
            return DrinkType.NORMAL;
        }

        @Override
        public boolean addIngredient(EntityPlayer cook, Ingredient ingredient, CookingVessel vessel) {
            boolean flag = super.addIngredient(cook, ingredient, vessel);
            this.calculateColor();
            return flag;
        }

        @Override
        public boolean removeIngredient(Ingredient ingredient) {
            boolean flag = super.removeIngredient(ingredient);
            this.calculateColor();
            return flag;
        }

        protected void calculateColor() {
            int size = 0;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            for (Ingredient ingredient : this.getIngredients()) {
                int color = ingredient.getMaterial().getRawColorCode();
                r += (float)(color >> 16 & 0xFF) / 255.0f;
                g += (float)(color >> 8 & 0xFF) / 255.0f;
                b += (float)(color & 0xFF) / 255.0f;
                ++size;
            }
            if (size > 0) {
                r = r / (float)size * 255.0f;
                g = g / (float)size * 255.0f;
                b = b / (float)size * 255.0f;
                this.color = (int)r << 16 | (int)g << 8 | (int)b;
            }
        }

        public int getColor() {
            return this.color | 0xFF000000;
        }

        @Override
        public Class<Drink> getType() {
            return Drink.class;
        }

        @Override
        public int getMaxIngredientLimit() {
            return 4;
        }

        @Override
        public Optional<Drink> build(CookingVessel vessel, EntityPlayer cook) {
            if (this.getIngredients().isEmpty()) {
                return Optional.empty();
            }
            for (Ingredient ingredient : this.getIngredients()) {
                ingredient.removeTrait(IngredientTrait.UNDERCOOKED);
            }
            FoodValueCounter counter = new FoodValueCounter(0.0f, 0.4f);
            this.apply(counter, vessel);
            float saturationModifier = counter.getSaturation();
            int foodLevel = counter.getHungerRegen();
            this.completed = new Drink(this.getIngredients(), this.getSeasonings(), this.getEffects(), foodLevel, saturationModifier, this.drinkType, this.color);
            return Optional.of(this.completed);
        }

        public static NBTTagCompound toNBT(Builder builder) {
            NBTTagCompound data = new NBTTagCompound();
            NBTTagList ingredientList = new NBTTagList();
            for (Ingredient ingredient : builder.getIngredients()) {
                ingredientList.func_74742_a((NBTBase)CuisinePersistenceCenter.serialize(ingredient));
            }
            data.func_74782_a("ingredients", (NBTBase)ingredientList);
            NBTTagList seasoningList = new NBTTagList();
            for (Seasoning seasoning : builder.getSeasonings()) {
                seasoningList.func_74742_a((NBTBase)CuisinePersistenceCenter.serialize(seasoning));
            }
            data.func_74782_a("seasonings", (NBTBase)seasoningList);
            NBTTagList nBTTagList = new NBTTagList();
            for (Effect effect : builder.getEffects()) {
                nBTTagList.func_74742_a((NBTBase)new NBTTagString(effect.getID()));
            }
            data.func_74782_a("effects", (NBTBase)nBTTagList);
            data.func_74778_a("type", builder.drinkType.getName());
            data.func_74768_a("color", builder.getColor());
            return data;
        }

        public static Builder fromNBT(NBTTagCompound data) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            ArrayList<Seasoning> seasonings = new ArrayList<Seasoning>();
            ArrayList<Effect> effects = new ArrayList<Effect>();
            NBTTagList ingredientList = data.func_150295_c("ingredients", 10);
            for (Object baseTag : ingredientList) {
                Ingredient ingredient;
                if (baseTag.func_74732_a() != 10 || (ingredient = CuisinePersistenceCenter.deserializeIngredient((NBTTagCompound)baseTag)) == null) continue;
                ingredients.add(ingredient);
            }
            NBTTagList seasoningList = data.func_150295_c("seasonings", 10);
            for (Object baseTag : seasoningList) {
                if (baseTag.func_74732_a() != 10) continue;
                seasonings.add(CuisinePersistenceCenter.deserializeSeasoning((NBTTagCompound)baseTag));
            }
            NBTTagList effectList = data.func_150295_c("effects", 8);
            for (NBTBase baseTag : effectList) {
                if (baseTag.func_74732_a() != 8) continue;
                effects.add(CulinaryHub.API_INSTANCE.findEffect(((NBTTagString)baseTag).func_150285_a_()));
            }
            Builder builder = new Builder(ingredients, seasonings, effects);
            builder.drinkType = DrinkType.get(data.func_74779_i("type"));
            if (builder.drinkType == null) {
                builder.drinkType = DrinkType.NORMAL;
            }
            builder.color = data.func_74762_e("color");
            return builder;
        }

        static {
            FEATURE_INPUTS.put((ProcessingInput)ItemDefinition.of((Item)Items.field_151126_ay), DrinkType.SMOOTHIE);
            FEATURE_INPUTS.put((ProcessingInput)ItemDefinition.of((Block)Blocks.field_150432_aD), DrinkType.SMOOTHIE);
            FEATURE_INPUTS.put((ProcessingInput)ItemDefinition.of((Block)Blocks.field_150403_cj), DrinkType.SMOOTHIE);
            FEATURE_INPUTS.put((ProcessingInput)OreDictDefinition.of((String)"slimeball"), DrinkType.GELO);
            FEATURE_INPUTS.put((ProcessingInput)OreDictDefinition.of((String)"foodGelatine"), DrinkType.GELO);
            FEATURE_INPUTS.put((ProcessingInput)OreDictDefinition.of((String)"ingotGelatin"), DrinkType.GELO);
            FEATURE_INPUTS.put((ProcessingInput)OreDictDefinition.of((String)"dustRedstone"), DrinkType.SODA);
        }
    }
}

