/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.internal.food;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.CookingVessel;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Effect;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.IngredientTrait;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.MaterialCategory;
import snownee.cuisine.api.Seasoning;
import snownee.cuisine.api.Spice;
import snownee.cuisine.api.prefab.DefaultCookedCollector;
import snownee.cuisine.api.util.SkillUtil;
import snownee.cuisine.internal.CuisinePersistenceCenter;
import snownee.cuisine.internal.food.FoodValueCounter;
import snownee.kiwi.util.NBTHelper;

public class Dish
extends CompositeFood {
    public static final ResourceLocation DISH_ID = new ResourceLocation("cuisine", "dish");
    private String modelType;

    public Dish(List<Ingredient> ingredients, List<Seasoning> seasonings, List<Effect> effects, int hungerHeal, float saturation) {
        super(ingredients, seasonings, effects, hungerHeal, saturation);
    }

    @Override
    public ResourceLocation getIdentifier() {
        return DISH_ID;
    }

    @Override
    public Collection<String> getKeywords() {
        return Arrays.asList("east-asian", "wok");
    }

    @Override
    public String getOrComputeModelType() {
        if (this.modelType != null) {
            return this.modelType;
        }
        this.modelType = this.ingredients.stream().anyMatch(i -> i.getMaterial().isUnderCategoryOf(MaterialCategory.FISH)) ? "fish0" : (this.ingredients.stream().anyMatch(i -> i.getMaterial() == CulinaryHub.CommonMaterials.RICE) ? "rice0" : (this.ingredients.stream().allMatch(i -> i.getMaterial().isUnderCategoryOf(MaterialCategory.MEAT)) ? (Math.random() >= 0.5 ? "meat1" : "meat0") : (this.ingredients.stream().allMatch(i -> i.getMaterial().isUnderCategoryOf(MaterialCategory.VEGETABLES)) ? (Math.random() >= 0.5 ? "veges0" : "veges1") : (Math.random() >= 0.5 ? "mixed0" : "mixed1"))));
        return this.modelType;
    }

    @Override
    public void setModelType(String type) {
        this.modelType = type;
    }

    @Override
    public ItemStack getBaseItem() {
        return new ItemStack((Item)CuisineRegistry.DISH);
    }

    @Override
    public void onEaten(ItemStack stack, World worldIn, EntityPlayer player) {
        super.onEaten(stack, worldIn, player);
        if (!worldIn.field_72995_K && CuisineConfig.HARDCORE.enable && CuisineConfig.HARDCORE.badSkillPunishment) {
            Potion potion;
            int countPlain = (int)this.getIngredients().stream().filter(i -> i.getAllTraits().contains((Object)IngredientTrait.PLAIN) || i.getAllTraits().contains((Object)IngredientTrait.UNDERCOOKED)).count();
            int countOvercooked = (int)this.getIngredients().stream().filter(i -> i.getAllTraits().contains((Object)IngredientTrait.OVERCOOKED)).count();
            if ((float)countPlain / (float)this.getIngredients().size() > 0.8f) {
                potion = worldIn.field_73012_v.nextBoolean() ? MobEffects.field_76419_f : MobEffects.field_76437_t;
                player.func_70690_d(new PotionEffect(potion, 300 * this.getIngredients().size()));
            }
            if ((float)countOvercooked / (float)this.getIngredients().size() > 0.8f) {
                potion = worldIn.field_73012_v.nextBoolean() ? MobEffects.field_76436_u : MobEffects.field_76431_k;
                player.func_70690_d(new PotionEffect(potion, 100 * this.getIngredients().size()));
            }
        }
    }

    public static NBTTagCompound serialize(Dish dish) {
        NBTTagCompound data = new NBTTagCompound();
        NBTTagList ingredientList = new NBTTagList();
        for (Object ingredient : dish.ingredients) {
            ingredientList.func_74742_a((NBTBase)CuisinePersistenceCenter.serialize((Ingredient)ingredient));
        }
        data.func_74782_a("ingredients", (NBTBase)ingredientList);
        NBTTagList seasoningList = new NBTTagList();
        for (Object seasoning : dish.seasonings) {
            seasoningList.func_74742_a((NBTBase)CuisinePersistenceCenter.serialize((Seasoning)seasoning));
        }
        data.func_74782_a("seasonings", (NBTBase)seasoningList);
        NBTTagList effectList = new NBTTagList();
        for (Effect effect : dish.effects) {
            effectList.func_74742_a((NBTBase)new NBTTagString(effect.getID()));
        }
        data.func_74782_a("effects", (NBTBase)effectList);
        String modelType = dish.getOrComputeModelType();
        if (modelType != null) {
            data.func_74778_a("type", modelType);
        }
        data.func_74768_a("foodLevel", dish.getFoodLevel());
        data.func_74776_a("saturation", dish.getSaturationModifier());
        data.func_74768_a("durability", dish.getServes());
        data.func_74768_a("maxServes", dish.getMaxServes());
        data.func_74776_a("useDuration", dish.getUseDurationModifier());
        return data;
    }

    public static Dish deserialize(NBTTagCompound data) {
        NBTHelper helper = NBTHelper.of((NBTTagCompound)data);
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        ArrayList<Seasoning> seasonings = new ArrayList<Seasoning>();
        ArrayList<Effect> effects = new ArrayList<Effect>();
        NBTTagList ingredientList = data.func_150295_c("ingredients", 10);
        for (Object baseTag : ingredientList) {
            if (baseTag.func_74732_a() != 10) continue;
            ingredients.add(CuisinePersistenceCenter.deserializeIngredient((NBTTagCompound)baseTag));
        }
        NBTTagList seasoningList = data.func_150295_c("seasonings", 10);
        for (Object baseTag : seasoningList) {
            if (baseTag.func_74732_a() != 10) continue;
            seasonings.add(CuisinePersistenceCenter.deserializeSeasoning((NBTTagCompound)baseTag));
        }
        NBTTagList effectList = data.func_150295_c("effects", 8);
        for (NBTBase baseTag : effectList) {
            if (baseTag.func_74732_a() != 8) continue;
            effects.add(CulinaryHub.API_INSTANCE.findEffect(((NBTTagString)baseTag).func_150285_a_()));
        }
        int serves = helper.getInt("durability");
        int maxServes = helper.getInt("maxServes");
        float duration = helper.getFloat("useDuration", 1.0f);
        int foodLevel = helper.getInt("foodLevel");
        float saturation = helper.getFloat("saturation");
        Dish dish = new Dish(ingredients, seasonings, effects, foodLevel, saturation);
        dish.setMaxServes(maxServes);
        dish.setServes(serves);
        dish.setUseDurationModifier(duration);
        dish.setModelType(helper.getString("type"));
        return dish;
    }

    public static final class Builder
    extends CompositeFood.Builder<Dish> {
        private Dish completed;
        private int water;
        private int oil;
        private int temperature;
        private Random rand = new Random();

        private Builder() {
            this(new ArrayList<Ingredient>(), new ArrayList<Seasoning>(), new ArrayList<Effect>());
        }

        Builder(List<Ingredient> ingredients, List<Seasoning> seasonings, List<Effect> effects) {
            super(ingredients, seasonings, effects);
        }

        @Override
        public Class<Dish> getType() {
            return Dish.class;
        }

        @Override
        public boolean canAddIntoThis(EntityPlayer cook, Ingredient ingredient, CookingVessel vessel) {
            if (ingredient.getForm() == Form.JUICE) {
                return false;
            }
            if (SkillUtil.hasPlayerLearnedSkill(cook, CulinaryHub.CommonSkills.BIGGER_SIZE)) {
                return this.getIngredients().size() < this.getMaxIngredientLimit() && ingredient.getMaterial().canAddInto(this, ingredient);
            }
            return (double)this.getIngredients().size() < (double)this.getMaxIngredientLimit() * 0.75 && ingredient.getMaterial().canAddInto(this, ingredient);
        }

        @Override
        public boolean addSeasoning(EntityPlayer cook, Seasoning seasoning, CookingVessel vessel) {
            boolean result = super.addSeasoning(cook, seasoning, vessel);
            if (result) {
                if (seasoning.hasKeyword("water")) {
                    this.water += seasoning.getSize() * 100;
                }
                if (seasoning.hasKeyword("oil")) {
                    this.oil += seasoning.getSize() * 100;
                }
            }
            return result;
        }

        public int getWaterAmount() {
            return this.water;
        }

        public int getOilAmount() {
            return this.oil;
        }

        public int getTemperature() {
            return this.temperature;
        }

        public void setWaterAmount(int water) {
            this.water = water;
        }

        public void setOilAmount(int oil) {
            this.oil = oil;
        }

        public void setTemperature(int temperature) {
            this.temperature = temperature;
        }

        @Override
        public Optional<Dish> build(CookingVessel vessel, EntityPlayer cook) {
            if (this.getIngredients().isEmpty()) {
                return Optional.empty();
            }
            if (this.completed != null) {
                return Optional.of(this.completed);
            }
            FoodValueCounter counter = new FoodValueCounter(0.0f, 0.4f);
            this.apply(counter, vessel);
            float saturationModifier = counter.getSaturation();
            int foodLevel = counter.getHungerRegen();
            int countMat = this.getIngredients().stream().map(Ingredient::getMaterial).collect(Collectors.toSet()).size();
            int serves = 8;
            if (countMat < 3) {
                serves -= (2 - countMat) * 3 + this.rand.nextInt(3);
            }
            DefaultCookedCollector collector = new DefaultCookedCollector(serves);
            int seasoningSize = 0;
            int waterSize = 0;
            for (Seasoning seasoning : this.getSeasonings()) {
                Spice spice = seasoning.getSpice();
                spice.onMade(this, seasoning, vessel, collector);
                if (seasoning.hasKeyword("water")) {
                    waterSize += seasoning.getSize();
                    continue;
                }
                if (seasoning.hasKeyword("oil")) continue;
                seasoningSize += seasoning.getSize();
            }
            boolean isPlain = seasoningSize == 0 || this.getIngredients().size() / seasoningSize / (1 + waterSize / 3) > 3;
            for (Ingredient ingredient : this.getIngredients()) {
                Material material = ingredient.getMaterial();
                Set<MaterialCategory> categories = material.getCategories();
                if (categories.contains((Object)MaterialCategory.SEAFOOD) || categories.contains((Object)MaterialCategory.FRUIT)) continue;
                if (isPlain) {
                    ingredient.addTrait(IngredientTrait.PLAIN);
                }
                EnumSet<Form> validForms = ingredient.getMaterial().getValidForms();
                int count = 0;
                for (Form form : new Form[]{Form.SLICED, Form.DICED, Form.MINCED, Form.SHREDDED, Form.PASTE}) {
                    if (!validForms.contains((Object)form)) continue;
                    ++count;
                }
                if (count <= 0 || ingredient.hasTrait(IngredientTrait.OVERCOOKED) || !(this.rand.nextFloat() > 0.35f * (float)(ingredient.getForm().ordinal() + 1))) continue;
                ingredient.addTrait(IngredientTrait.UNDERCOOKED);
            }
            for (Ingredient ingredient : this.getIngredients()) {
                ingredient.getMaterial().onMade(this, ingredient, vessel, collector);
            }
            this.completed = new Dish(this.getIngredients(), this.getSeasonings(), this.getEffects(), foodLevel, saturationModifier);
            collector.apply(this.completed, cook);
            this.completed.getOrComputeModelType();
            return Optional.of(this.completed);
        }

        public static Builder create() {
            return new Builder();
        }

        public static NBTTagCompound toNBT(Builder builder) {
            NBTTagCompound data = new NBTTagCompound();
            NBTTagList ingredientList = new NBTTagList();
            for (Ingredient ingredient : builder.getIngredients()) {
                ingredientList.func_74742_a((NBTBase)CuisinePersistenceCenter.serialize(ingredient));
            }
            data.func_74782_a("ingredients", (NBTBase)ingredientList);
            NBTTagList seasoningList = new NBTTagList();
            for (Seasoning seasoning : builder.getSeasonings()) {
                seasoningList.func_74742_a((NBTBase)CuisinePersistenceCenter.serialize(seasoning));
            }
            data.func_74782_a("seasonings", (NBTBase)seasoningList);
            NBTTagList nBTTagList = new NBTTagList();
            for (Effect effect : builder.getEffects()) {
                nBTTagList.func_74742_a((NBTBase)new NBTTagString(effect.getID()));
            }
            data.func_74782_a("effects", (NBTBase)nBTTagList);
            data.func_74768_a("water", builder.getWaterAmount());
            data.func_74768_a("oil", builder.getOilAmount());
            data.func_74768_a("temperature", builder.getTemperature());
            return data;
        }

        public static Builder fromNBT(NBTTagCompound data) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            ArrayList<Seasoning> seasonings = new ArrayList<Seasoning>();
            ArrayList<Effect> effects = new ArrayList<Effect>();
            NBTTagList ingredientList = data.func_150295_c("ingredients", 10);
            for (Object baseTag : ingredientList) {
                Ingredient ingredient;
                if (baseTag.func_74732_a() != 10 || (ingredient = CuisinePersistenceCenter.deserializeIngredient((NBTTagCompound)baseTag)) == null) continue;
                ingredients.add(ingredient);
            }
            NBTTagList seasoningList = data.func_150295_c("seasonings", 10);
            for (Object baseTag : seasoningList) {
                if (baseTag.func_74732_a() != 10) continue;
                seasonings.add(CuisinePersistenceCenter.deserializeSeasoning((NBTTagCompound)baseTag));
            }
            NBTTagList effectList = data.func_150295_c("effects", 8);
            for (NBTBase baseTag : effectList) {
                if (baseTag.func_74732_a() != 8) continue;
                effects.add(CulinaryHub.API_INSTANCE.findEffect(((NBTTagString)baseTag).func_150285_a_()));
            }
            Builder builder = new Builder(ingredients, seasonings, effects);
            if (data.func_150297_b("water", 3)) {
                builder.setWaterAmount(data.func_74762_e("water"));
            }
            if (data.func_150297_b("oil", 3)) {
                builder.setOilAmount(data.func_74762_e("oil"));
            }
            if (data.func_150297_b("temperature", 3)) {
                builder.setTemperature(data.func_74762_e("temperature"));
            }
            return builder;
        }
    }
}

