/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.internal.effect;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.EffectCollector;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.prefab.DefaultTypes;
import snownee.cuisine.api.prefab.SimpleEffectImpl;

public class EffectPotions
extends SimpleEffectImpl {
    List<PotionEffect> effects = new ArrayList<PotionEffect>(4);

    public EffectPotions(String name) {
        super(name, 0);
    }

    public EffectPotions addPotionEffect(PotionEffect effect) {
        this.effects.add(effect);
        return this;
    }

    @Override
    public void onEaten(ItemStack stack, EntityPlayer player, CompositeFood food, List<Ingredient> ingredients, EffectCollector collector) {
        double size = ingredients.size();
        int modifier = 0;
        int count = 0;
        for (Ingredient ingredient : ingredients) {
            if (ingredient == null) {
                count += Form.JUICE.ordinal();
                continue;
            }
            count += ingredient.getForm().ordinal();
        }
        if ((double)count / size > 4.0) {
            modifier = 1;
        }
        for (PotionEffect effect : this.effects) {
            collector.addEffect(DefaultTypes.POTION, new PotionEffect(effect.func_188419_a(), Math.max(0, (int)((double)effect.func_76459_b() * size * 2.0 / (double)(modifier + 1) / 4.0)), effect.func_76458_c() + modifier, effect.func_82720_e(), effect.func_188418_e()));
        }
    }

    @Override
    public int getColor() {
        return PotionUtils.func_185181_a(this.effects);
    }
}

