/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.internal.capabilities;

import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.fluids.CuisineFluids;
import snownee.kiwi.util.NBTHelper;

@Mod.EventBusSubscriber(modid="cuisine")
public class GlassBottleHandler {
    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.func_77973_b() instanceof ItemGlassBottle) {
            ResourceLocation resourceLocation = new ResourceLocation("cuisine", "fluid_container");
            GlassBottleWrapper fluidHandler = new GlassBottleWrapper(stack);
            event.addCapability(resourceLocation, (ICapabilityProvider)fluidHandler);
        } else if (CuisineConfig.GENERAL.attachWaterBottleCapability && stack.func_77973_b() == Items.field_151068_bn) {
            ResourceLocation resourceLocation = new ResourceLocation("cuisine", "fluid_container");
            WaterBottleWrapper fluidHandler = new WaterBottleWrapper(stack);
            event.addCapability(resourceLocation, (ICapabilityProvider)fluidHandler);
        }
    }

    public static class WaterBottleWrapper
    extends FluidHandlerItemStackSimple {
        public WaterBottleWrapper(ItemStack stack) {
            super(stack, 250);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return false;
        }

        public FluidStack getFluid() {
            return new FluidStack(FluidRegistry.WATER, 250);
        }

        protected void setFluid(FluidStack fluid) {
        }

        protected void setContainerToEmpty() {
            super.setContainerToEmpty();
            this.container = new ItemStack(Items.field_151069_bo);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY && PotionUtils.func_185191_c((ItemStack)this.container) != PotionTypes.field_185230_b) {
                return false;
            }
            return super.hasCapability(capability, facing);
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY && PotionUtils.func_185191_c((ItemStack)this.container) != PotionTypes.field_185230_b) {
                return null;
            }
            return (T)super.getCapability(capability, facing);
        }
    }

    public static class GlassBottleWrapper
    extends FluidHandlerItemStackSimple {
        public GlassBottleWrapper(ItemStack stack) {
            super(stack, 250);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FluidRegistry.WATER || fluid.getFluid() == CuisineFluids.JUICE || fluid.getFluid().getName().equals("milk");
        }

        protected void setFluid(FluidStack fluid) {
            if (fluid.getFluid() == FluidRegistry.WATER) {
                this.container = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
            } else {
                this.container = new ItemStack((Item)CuisineRegistry.BOTTLE);
                super.setFluid(fluid);
            }
        }

        protected void setContainerToEmpty() {
            super.setContainerToEmpty();
            this.container = new ItemStack(Items.field_151069_bo);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY && NBTHelper.of((ItemStack)this.container).hasTag("potion", 8)) {
                return false;
            }
            return super.hasCapability(capability, facing);
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY && NBTHelper.of((ItemStack)this.container).hasTag("potion", 8)) {
                return null;
            }
            return (T)super.getCapability(capability, facing);
        }
    }
}

