/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.internal.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.prefab.SimpleFoodContainerImpl;
import snownee.cuisine.internal.food.Drink;

public class DrinkContainer
extends SimpleFoodContainerImpl
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    @Override
    @Nonnull
    public ItemStack getEmptyContainer(ItemStack currentContainer) {
        if (this.food != null && this.food.getClass() == Drink.class) {
            return ((Drink)this.food).getDrinkType().getContainerPost();
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CulinaryCapabilities.FOOD_CONTAINER;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CulinaryCapabilities.FOOD_CONTAINER) {
            return (T)CulinaryCapabilities.FOOD_CONTAINER.cast((Object)this);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        if (this.food == null) {
            return new NBTTagCompound();
        }
        return CulinaryHub.API_INSTANCE.serialize(this.food);
    }

    public void deserializeNBT(NBTTagCompound data) {
        ResourceLocation id = new ResourceLocation(data.func_74779_i("FoodType"));
        this.food = CulinaryHub.API_INSTANCE.deserialize(id, data);
    }
}

