/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.internal.capabilities;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.CulinarySkillPoint;
import snownee.cuisine.api.CulinarySkillPointContainer;
import snownee.cuisine.api.prefab.SimpleCulinarySkillPointContainerImpl;

public final class CulinarySkillCapability {
    private CulinarySkillCapability() {
        throw new UnsupportedOperationException();
    }

    public static void init() {
        CapabilityManager.INSTANCE.register(CulinarySkillPointContainer.class, (Capability.IStorage)new Storage(), SimpleCulinarySkillPointContainerImpl::new);
        MinecraftForge.EVENT_BUS.register(EventListener.class);
    }

    static class Storage
    implements Capability.IStorage<CulinarySkillPointContainer> {
        Storage() {
        }

        @Nullable
        public NBTBase writeNBT(Capability<CulinarySkillPointContainer> capability, CulinarySkillPointContainer instance, EnumFacing side) {
            NBTTagCompound data = new NBTTagCompound();
            for (CulinarySkillPoint skillPoint : instance.getAvailableSkillPoints()) {
                data.func_74768_a(skillPoint.toString(), instance.getSkillPoint(skillPoint));
            }
            return data;
        }

        public void readNBT(Capability<CulinarySkillPointContainer> capability, CulinarySkillPointContainer instance, EnumFacing side, NBTBase data) {
            if (data instanceof NBTTagCompound) {
                for (CulinarySkillPoint skillPoint : instance.getAvailableSkillPoints()) {
                    instance.setSkillPoint(skillPoint, ((NBTTagCompound)data).func_74762_e(skillPoint.toString()));
                }
            }
        }
    }

    public static class DefaultProvider
    extends SimpleCulinarySkillPointContainerImpl
    implements ICapabilitySerializable<NBTTagCompound> {
        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CulinaryCapabilities.CULINARY_SKILL;
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CulinaryCapabilities.CULINARY_SKILL) {
                return (T)CulinaryCapabilities.CULINARY_SKILL.cast((Object)this);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound data = new NBTTagCompound();
            for (CulinarySkillPoint skillPoint : this.getAvailableSkillPoints()) {
                data.func_74768_a(skillPoint.toString(), this.getSkillPoint(skillPoint));
            }
            return data;
        }

        public void deserializeNBT(NBTTagCompound data) {
            for (CulinarySkillPoint skillPoint : this.getAvailableSkillPoints()) {
                this.setSkillPoint(skillPoint, data.func_74762_e(skillPoint.toString()));
            }
        }
    }

    static final class EventListener {
        private EventListener() {
            throw new UnsupportedOperationException("No instance for you");
        }

        @SubscribeEvent
        public static void onPlayerGatherCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityPlayer && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("cuisine", "culinary_skill"), (ICapabilityProvider)new DefaultProvider());
            }
        }

        @SubscribeEvent
        public static void reSyncDataOnPlayerDeath(PlayerEvent.Clone event) {
            CulinarySkillPointContainer original;
            CulinarySkillPointContainer skill = (CulinarySkillPointContainer)event.getEntityPlayer().getCapability(CulinaryCapabilities.CULINARY_SKILL, null);
            if (skill != null && (original = (CulinarySkillPointContainer)event.getOriginal().getCapability(CulinaryCapabilities.CULINARY_SKILL, null)) != null) {
                for (CulinarySkillPoint p : original.getAvailableSkillPoints()) {
                    int syncedPoints = original.getSkillPoint(p);
                    if (event.isWasDeath() && CuisineConfig.HARDCORE.enable && CuisineConfig.HARDCORE.loseSkillPointsOnDeath) {
                        syncedPoints = (int)((double)syncedPoints * CuisineConfig.HARDCORE.skillPointsRetainRatio);
                    }
                    skill.setSkillPoint(p, syncedPoints);
                }
            }
        }
    }
}

