/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.internal;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Effect;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.IngredientTrait;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.Seasoning;
import snownee.cuisine.api.Spice;

public interface CuisinePersistenceCenter {
    public static NBTTagCompound serialize(Ingredient ingredient) {
        NBTTagCompound data = new NBTTagCompound();
        if (ingredient.getMaterial() == null) {
            return data;
        }
        data.func_74778_a("material", ingredient.getMaterial().getID());
        data.func_74778_a("form", ingredient.getForm().name());
        data.func_74768_a("doneness", ingredient.getDoneness());
        data.func_74783_a("characteristics", ingredient.getAllTraits().stream().mapToInt(Enum::ordinal).toArray());
        NBTTagList effectList = new NBTTagList();
        for (Effect effect : ingredient.getEffects()) {
            effectList.func_74742_a((NBTBase)new NBTTagString(effect.getID()));
        }
        data.func_74782_a("effects", (NBTBase)effectList);
        return data;
    }

    public static NBTTagCompound serialize(Seasoning seasoning) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("spice", seasoning.getSpice().getID());
        data.func_74768_a("size", seasoning.getSize());
        return data;
    }

    @Nullable
    public static Ingredient deserializeIngredient(@Nonnull NBTTagCompound data) {
        if (!data.func_150297_b("material", 8)) {
            return null;
        }
        String materialKey = data.func_74779_i("material");
        Material material = CulinaryHub.API_INSTANCE.findMaterial(materialKey);
        if (material == null) {
            return null;
        }
        Form form = Form.valueOf(data.func_74779_i("form"));
        EnumSet<IngredientTrait> traits = EnumSet.noneOf(IngredientTrait.class);
        for (int id : data.func_74759_k("characteristics")) {
            traits.add(IngredientTrait.VALUES[id]);
        }
        Ingredient result = new Ingredient(material, form, traits);
        if (data.func_150297_b("doneness", 3)) {
            result.setDoneness(data.func_74762_e("doneness"));
        }
        for (NBTBase baseTag : data.func_150295_c("effects", 8)) {
            Effect e;
            if (!(baseTag instanceof NBTTagString) || (e = CulinaryHub.API_INSTANCE.findEffect(((NBTTagString)baseTag).func_150285_a_())) == null) continue;
            result.addEffect(e);
        }
        return result;
    }

    public static Seasoning deserializeSeasoning(@Nonnull NBTTagCompound data) {
        Spice spice = CulinaryHub.API_INSTANCE.findSpice(data.func_74779_i("spice"));
        if (spice == null) {
            throw new IllegalArgumentException();
        }
        int quantity = data.func_74762_e("size");
        return new Seasoning(spice, quantity);
    }
}

