/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.CuisineAPI;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Effect;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.MaterialCategory;
import snownee.cuisine.api.Recipe;
import snownee.cuisine.api.Spice;
import snownee.cuisine.api.prefab.MaterialBuilder;
import snownee.cuisine.api.prefab.SimpleEffectImpl;
import snownee.cuisine.api.prefab.SimpleMaterialImpl;
import snownee.cuisine.api.prefab.SimpleSpiceImpl;
import snownee.cuisine.crafting.DrinkBrewingRecipe;
import snownee.cuisine.fluids.CuisineFluids;
import snownee.cuisine.fluids.FluidJuice;
import snownee.cuisine.internal.CuisinePersistenceCenter;
import snownee.cuisine.internal.IdentifierBasedRegistry;
import snownee.cuisine.internal.effect.EffectCurePotions;
import snownee.cuisine.internal.effect.EffectExperienced;
import snownee.cuisine.internal.effect.EffectHarmony;
import snownee.cuisine.internal.effect.EffectHeatResistance;
import snownee.cuisine.internal.effect.EffectPotions;
import snownee.cuisine.internal.effect.EffectRare;
import snownee.cuisine.internal.effect.EffectSpooky;
import snownee.cuisine.internal.effect.EffectSustainedRelease;
import snownee.cuisine.internal.effect.EffectTeleport;
import snownee.cuisine.internal.food.Dish;
import snownee.cuisine.internal.food.Drink;
import snownee.cuisine.internal.material.MaterialApple;
import snownee.cuisine.internal.material.MaterialChili;
import snownee.cuisine.internal.material.MaterialChorusFruit;
import snownee.cuisine.internal.material.MaterialPufferfish;
import snownee.cuisine.internal.material.MaterialPumpkin;
import snownee.cuisine.internal.material.MaterialRice;
import snownee.cuisine.internal.material.MaterialTofu;
import snownee.cuisine.internal.material.MaterialTomato;
import snownee.cuisine.internal.material.MaterialWithEffect;
import snownee.cuisine.internal.spice.SpiceChiliPowder;
import snownee.cuisine.items.ItemBasicFood;
import snownee.cuisine.items.ItemCrops;
import snownee.cuisine.library.RarityManager;
import snownee.kiwi.util.OreUtil;
import snownee.kiwi.util.definition.ItemDefinition;

public final class CuisineInternalGateway
implements CuisineAPI {
    public static CuisineInternalGateway INSTANCE;
    private final IdentifierBasedRegistry<Material> materialRegistry = new IdentifierBasedRegistry();
    private final IdentifierBasedRegistry<Spice> spiceRegistry = new IdentifierBasedRegistry();
    private final IdentifierBasedRegistry<Effect> effectRegistry = new IdentifierBasedRegistry();
    private final IdentifierBasedRegistry<Recipe> recipeRegistry = new IdentifierBasedRegistry();
    private final Map<String, Class<?>> foodTypes = new HashMap();
    private final Map<String, Function<? extends CompositeFood, NBTTagCompound>> serializers = new HashMap<String, Function<? extends CompositeFood, NBTTagCompound>>();
    private final Map<String, Function<NBTTagCompound, ? extends CompositeFood>> deserializers = new HashMap<String, Function<NBTTagCompound, ? extends CompositeFood>>();
    public final Map<ItemDefinition, Ingredient> itemIngredients = new HashMap<ItemDefinition, Ingredient>();
    public final Map<String, Ingredient> oreDictIngredients = new HashMap<String, Ingredient>();
    public final Map<String, Ingredient> fluidIngredients = new HashMap<String, Ingredient>();
    public final Map<ItemDefinition, Spice> itemToSpiceMapping = new HashMap<ItemDefinition, Spice>();
    public final Map<String, Spice> oreDictToSpiceMapping = new HashMap<String, Spice>();
    public final Map<String, Spice> fluidToSpiceMapping = new HashMap<String, Spice>();

    private CuisineInternalGateway() {
    }

    @Override
    public Material register(Material material) {
        Material actualMaterial = this.materialRegistry.register(material.getID(), material);
        if (actualMaterial == material && actualMaterial.isUnderCategoryOf(MaterialCategory.FRUIT)) {
            DrinkBrewingRecipe.add(material);
        }
        return actualMaterial;
    }

    @Override
    public Spice register(Spice spice) {
        return this.spiceRegistry.register(spice.getID(), spice);
    }

    @Override
    public Effect register(Effect effect) {
        return this.effectRegistry.register(effect.getID(), effect);
    }

    @Override
    public Recipe register(Recipe recipe) {
        return this.recipeRegistry.register(recipe.name(), recipe);
    }

    @Override
    public <F extends CompositeFood> void registerFoodType(ResourceLocation uniqueLocator, Class<F> typeToken, Function<F, NBTTagCompound> serializer, Function<NBTTagCompound, F> deserializer) {
        if (!uniqueLocator.func_110624_b().equals(Loader.instance().activeModContainer().getModId())) {
            throw new IllegalStateException("Registering at the time when current mod container mismatches");
        }
        String id = uniqueLocator.toString();
        this.foodTypes.putIfAbsent(id, typeToken);
        this.serializers.putIfAbsent(id, serializer);
        this.deserializers.putIfAbsent(id, deserializer);
    }

    @Override
    public <F extends CompositeFood> NBTTagCompound serialize(F dishObject) {
        String identifier = dishObject.getIdentifier().toString();
        Function<? extends CompositeFood, NBTTagCompound> serializer = this.serializers.get(identifier);
        if (serializer == null) {
            return new NBTTagCompound();
        }
        NBTTagCompound data = serializer.apply(dishObject);
        data.func_74778_a("FoodType", identifier);
        return data;
    }

    @Override
    @Nullable
    public <F extends CompositeFood> F deserialize(ResourceLocation identifier, NBTTagCompound data) {
        ResourceLocation rl = new ResourceLocation(data.func_74779_i("FoodType"));
        if (!identifier.equals((Object)rl)) {
            Cuisine.logger.warn("Cannot use {} to deserialize CompositeFood with type of {}", (Object)identifier, (Object)rl);
            return null;
        }
        Function<NBTTagCompound, ? extends CompositeFood> deserializer = this.deserializers.get(identifier.toString());
        if (deserializer == null) {
            return null;
        }
        return (F)deserializer.apply(data);
    }

    @Override
    public Collection<Material> getKnownMaterials() {
        return Collections.unmodifiableCollection(this.materialRegistry.getView().values());
    }

    @Override
    public Collection<Spice> getKnownSpices() {
        return Collections.unmodifiableCollection(this.spiceRegistry.getView().values());
    }

    @Override
    public Collection<Effect> getKnownEffects() {
        return Collections.unmodifiableCollection(this.effectRegistry.getView().values());
    }

    @Override
    public Material findMaterial(String uniqueId) {
        return this.materialRegistry.lookup(uniqueId);
    }

    @Override
    public Spice findSpice(String uniqueId) {
        return this.spiceRegistry.lookup(uniqueId);
    }

    @Override
    public Effect findEffect(String uniqueId) {
        return this.effectRegistry.lookup(uniqueId);
    }

    @Override
    public Ingredient findIngredient(ItemStack item) {
        if (item.func_190926_b()) {
            return null;
        }
        if (item.func_77973_b() == CuisineRegistry.INGREDIENT) {
            NBTTagCompound data = item.func_77978_p();
            if (data == null) {
                return null;
            }
            return CuisinePersistenceCenter.deserializeIngredient(data);
        }
        ItemDefinition itemDefinition = ItemDefinition.of((ItemStack)item);
        Ingredient ingredient = this.itemIngredients.get(itemDefinition);
        if (ingredient != null) {
            ingredient = ingredient.copy();
        } else {
            List possibleOreEntries = OreUtil.getOreNames((ItemStack)item);
            for (String entry : possibleOreEntries) {
                ingredient = this.oreDictIngredients.get(entry);
                if (ingredient == null) continue;
                ingredient = ingredient.copy();
                break;
            }
        }
        if (ingredient != null && RarityManager.getRarity(item).ordinal() > 0) {
            ingredient.addEffect(CulinaryHub.CommonEffects.RARE);
        }
        return ingredient;
    }

    @Override
    public Spice findSpice(ItemStack item) {
        Spice spice = this.itemToSpiceMapping.get(ItemDefinition.of((ItemStack)item));
        if (spice != null) {
            return spice;
        }
        List possibleOreEntries = OreUtil.getOreNames((ItemStack)item);
        for (String entry : possibleOreEntries) {
            spice = this.oreDictToSpiceMapping.get(entry);
            if (spice == null) continue;
            return spice;
        }
        return null;
    }

    @Override
    public Ingredient findIngredient(@Nullable FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        if (fluid.getFluid() == CuisineFluids.JUICE) {
            if (fluid.tag == null || !fluid.tag.func_150297_b("material", 8)) {
                return null;
            }
            Material material = this.findMaterial(fluid.tag.func_74779_i("material"));
            return material == null ? null : new Ingredient(material, Form.JUICE);
        }
        Ingredient ingredient = this.fluidIngredients.get(fluid.getFluid().getName());
        return ingredient == null ? null : ingredient.copy();
    }

    @Override
    public Spice findSpice(@Nullable FluidStack fluid) {
        return fluid == null ? null : this.fluidToSpiceMapping.get(fluid.getFluid().getName());
    }

    @Override
    public boolean isKnownIngredient(ItemStack item) {
        return this.findIngredient(item) != null;
    }

    @Override
    public boolean isKnownSpice(ItemStack item) {
        if (item.func_190926_b()) {
            return false;
        }
        if (this.itemToSpiceMapping.containsKey(ItemDefinition.of((ItemStack)item))) {
            return true;
        }
        List possibleOreEntries = OreUtil.getOreNames((ItemStack)item);
        for (String entry : possibleOreEntries) {
            if (!this.oreDictToSpiceMapping.containsKey(entry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isKnownIngredient(@Nullable FluidStack fluid) {
        return this.findIngredient(fluid) != null;
    }

    @Override
    public boolean isKnownSpice(@Nullable FluidStack fluid) {
        return fluid != null && this.fluidToSpiceMapping.containsKey(fluid.getFluid().getName());
    }

    public static void init() {
        CuisineInternalGateway api;
        INSTANCE = api = new CuisineInternalGateway();
        CulinaryHub.API_INSTANCE = INSTANCE;
        api.registerFoodType(Dish.DISH_ID, Dish.class, Dish::serialize, Dish::deserialize);
        api.registerFoodType(Drink.DRINK_ID, Drink.class, Drink::serialize, Drink::deserialize);
        api.register(new EffectExperienced());
        api.register(new EffectPotions("golden_apple").addPotionEffect(new PotionEffect(MobEffects.field_76428_l, 100, 1)).addPotionEffect(new PotionEffect(MobEffects.field_76444_x, 2400, 0)));
        api.register(new EffectPotions("golden_apple_enchanted").addPotionEffect(new PotionEffect(MobEffects.field_76428_l, 400, 1)).addPotionEffect(new PotionEffect(MobEffects.field_76429_m, 6000, 0)).addPotionEffect(new PotionEffect(MobEffects.field_76426_n, 6000, 0)).addPotionEffect(new PotionEffect(MobEffects.field_76444_x, 2400, 3)));
        api.register(new SimpleEffectImpl("flavor_enhancer", 16448210));
        api.register(new EffectCurePotions());
        api.register(new EffectHarmony());
        api.register(new EffectTeleport());
        api.register(new SimpleEffectImpl("always_edible", 0xFFFFEE));
        api.register(new EffectPotions("jump_boost").addPotionEffect(new PotionEffect(MobEffects.field_76430_j, 400, 1)));
        api.register(new EffectPotions("power").addPotionEffect(new PotionEffect(MobEffects.field_76420_g, 400, 1)));
        api.register(new EffectPotions("night_vision").addPotionEffect(new PotionEffect(MobEffects.field_76439_r, 400, 0)));
        api.register(new EffectPotions("longer_night_vision").addPotionEffect(new PotionEffect(MobEffects.field_76439_r, 1200, 0)));
        api.register(new EffectPotions("hot").addPotionEffect(new PotionEffect((Potion)CuisineRegistry.HOT, 1200, 0)));
        api.register(new EffectPotions("dispersal").addPotionEffect(new PotionEffect((Potion)CuisineRegistry.DISPERSAL, 400, 1)));
        api.register(new EffectPotions("pufferfish_poison").addPotionEffect(new PotionEffect(MobEffects.field_76436_u, 1200, 3)).addPotionEffect(new PotionEffect(MobEffects.field_76438_s, 300, 2)).addPotionEffect(new PotionEffect(MobEffects.field_76431_k, 300, 1)));
        api.register(new EffectPotions("water_breathing").addPotionEffect(new PotionEffect(MobEffects.field_76427_o, 1500, 0)));
        api.register(new EffectHeatResistance());
        api.register(new EffectSustainedRelease());
        api.register(new EffectSpooky());
        api.register(new EffectRare());
        Arrays.asList(MaterialBuilder.of("peanut").rawColor(-8531).category(MaterialCategory.NUT).form(Form.MINCED, Form.PASTE).build(), MaterialBuilder.of("sesame").rawColor(-15000805).category(MaterialCategory.GRAIN).build(), MaterialBuilder.of("soybean").rawColor(-2048665).category(MaterialCategory.GRAIN).build(), new MaterialRice("rice"), new MaterialTomato("tomato"), new MaterialChili("chili"), MaterialBuilder.of("garlic").rawColor(-32).category(MaterialCategory.VEGETABLES).form(Form.DICED, Form.MINCED, Form.PASTE).effect(CulinaryHub.CommonEffects.DISPERSAL).build(), MaterialBuilder.of("ginger").rawColor(-1828).category(MaterialCategory.VEGETABLES).build(), MaterialBuilder.of("sichuan_pepper").rawColor(-8511203).category(MaterialCategory.UNKNOWN).build(), MaterialBuilder.of("scallion").rawColor(-12609717).form(Form.SLICED, Form.SHREDDED, Form.MINCED, Form.PASTE).build(), MaterialBuilder.of("turnip").rawColor(-3557457).form(Form.ALL_FORMS_INCLUDING_JUICE).category(MaterialCategory.VEGETABLES).build(), MaterialBuilder.of("chinese_cabbage").rawColor(-1966111).form(Form.SLICED, Form.SHREDDED, Form.MINCED, Form.PASTE).category(MaterialCategory.VEGETABLES).build(), MaterialBuilder.of("lettuce").rawColor(-14433485).form(Form.SLICED, Form.SHREDDED, Form.MINCED, Form.PASTE, Form.JUICE).category(MaterialCategory.VEGETABLES).build(), MaterialBuilder.of("corn").rawColor(-3227867).saturation(2.0f).category(MaterialCategory.GRAIN).form(Form.MINCED, Form.JUICE).build(), MaterialBuilder.of("cucumber").rawColor(-572725315).category(MaterialCategory.VEGETABLES).form(Form.ALL_FORMS_INCLUDING_JUICE).build(), MaterialBuilder.of("green_pepper").rawColor(-15107820).category(MaterialCategory.VEGETABLES).form(Form.SLICED, Form.SHREDDED, Form.MINCED, Form.PASTE).build(), MaterialBuilder.of("red_pepper").rawColor(-8581357).category(MaterialCategory.VEGETABLES).form(Form.SLICED, Form.SHREDDED, Form.MINCED, Form.PASTE).build(), MaterialBuilder.of("leek").rawColor(-15100888).category(MaterialCategory.VEGETABLES).form(Form.CUBED, Form.MINCED, Form.PASTE).build(), MaterialBuilder.of("onion").rawColor(-17409).category(MaterialCategory.VEGETABLES).form(Form.ALL_FORMS_INCLUDING_JUICE).build(), MaterialBuilder.of("eggplant").rawColor(14471829).category(MaterialCategory.VEGETABLES).form(Form.ALL_FORMS).build(), MaterialBuilder.of("spinach").rawColor(-15831787).category(MaterialCategory.VEGETABLES).form(Form.SLICED, Form.SHREDDED, Form.MINCED, Form.PASTE, Form.JUICE).effect(CulinaryHub.CommonEffects.POWER).build(), new MaterialTofu("tofu"), new MaterialChorusFruit("chorus_fruit"), new MaterialApple("apple"), MaterialBuilder.of("golden_apple").rawColor(-1782472).category(MaterialCategory.FRUIT).form(Form.ALL_FORMS_INCLUDING_JUICE).category(MaterialCategory.SUPERNATURAL).saturation(0.3f).effect(CulinaryHub.CommonEffects.GOLDEN_APPLE).build(), new MaterialWithEffect("golden_apple_enchanted", CulinaryHub.CommonEffects.GOLDEN_APPLE_ENCHANTED, -1782472, 0, 1, 1, 1, 0.3f, new MaterialCategory[]{MaterialCategory.FRUIT, MaterialCategory.SUPERNATURAL}){

            @Override
            public boolean hasGlowingOverlay(Ingredient ingredient) {
                return true;
            }
        }.setValidForms(Form.ALL_FORMS_INCLUDING_JUICE), MaterialBuilder.of("melon").rawColor(-769226).category(MaterialCategory.FRUIT).form(Form.CUBED, Form.SLICED, Form.DICED, Form.MINCED, Form.PASTE, Form.JUICE).build(), new MaterialPumpkin("pumpkin"), MaterialBuilder.of("carrot").rawColor(-1538531).saturation(0.1f).category(MaterialCategory.VEGETABLES).effect(CulinaryHub.CommonEffects.NIGHT_VISION).form(Form.ALL_FORMS_INCLUDING_JUICE).build(), MaterialBuilder.of("golden_carrot").rawColor(14393875).category(MaterialCategory.VEGETABLES).effect(CulinaryHub.CommonEffects.LONGER_NIGHT_VISION).form(Form.ALL_FORMS_INCLUDING_JUICE).build(), MaterialBuilder.of("potato").rawColor(-3764682).heatValue(2).saturation(2.0f).category(MaterialCategory.GRAIN).form(Form.ALL_FORMS).build(), MaterialBuilder.of("beetroot").rawColor(-8442327).category(MaterialCategory.VEGETABLES).form(Form.ALL_FORMS_INCLUDING_JUICE).build(), MaterialBuilder.of("mushroom").rawColor(-10006976).category(MaterialCategory.VEGETABLES).form(Form.ALL_FORMS).build(), MaterialBuilder.of("egg").rawColor(-3491187).saturation(0.2f).category(MaterialCategory.PROTEIN).build(), MaterialBuilder.of("chicken").rawColor(-929599).category(MaterialCategory.MEAT).form(Form.ALL_FORMS).build(), MaterialBuilder.of("beef").rawColor(-3392460).category(MaterialCategory.MEAT).form(Form.ALL_FORMS).build(), MaterialBuilder.of("pork").rawColor(-2133904).category(MaterialCategory.MEAT).form(Form.ALL_FORMS).build(), MaterialBuilder.of("mutton").rawColor(-3917262).saturation(0.0f).category(MaterialCategory.MEAT).form(Form.ALL_FORMS).build(), MaterialBuilder.of("rabbit").rawColor(-4882580).saturation(0.1f).category(MaterialCategory.MEAT).form(Form.ALL_FORMS).effect(CulinaryHub.CommonEffects.JUMP_BOOST).build(), MaterialBuilder.of("fish").rawColor(-10583426).category(MaterialCategory.FISH).form(Form.ALL_FORMS).build(), new MaterialPufferfish("pufferfish"), MaterialBuilder.of("pickled").rawColor(-13784).saturation(0.3f).effect(CulinaryHub.CommonEffects.ALWAYS_EDIBLE).form(Form.ALL_FORMS).build(), MaterialBuilder.of("bamboo_shoot").rawColor(16379101).effect(CulinaryHub.CommonEffects.ALWAYS_EDIBLE).form(Form.ALL_FORMS).build(), MaterialBuilder.of("cactus").rawColor(11123864).saturation(-0.1f).effect(CulinaryHub.CommonEffects.HEAT_RESISTANCE).form(Form.CUBED, Form.DICED, Form.JUICE).build(), MaterialBuilder.of("water").rawColor(0x55DDDDFF).boilHeat(100.0f).saturation(-0.1f).form(Form.JUICE).build(), MaterialBuilder.of("milk").rawColor(-855638017).boilHeat(100.0f).saturation(-0.1f).category(MaterialCategory.PROTEIN).form(Form.JUICE).build(), MaterialBuilder.of("soy_milk").rawColor(-15831787).saturation(-0.1f).category(MaterialCategory.PROTEIN).form(Form.JUICE).build(), MaterialBuilder.of("mandarin").rawColor(15763993).saturation(-0.1f).category(MaterialCategory.FRUIT).form(Form.JUICE).build(), MaterialBuilder.of("citron").rawColor(14535768).saturation(-0.1f).category(MaterialCategory.FRUIT).form(Form.JUICE).build(), MaterialBuilder.of("pomelo").rawColor(16250494).saturation(-0.1f).category(MaterialCategory.FRUIT).form(Form.JUICE).category(MaterialCategory.FRUIT).form(Form.JUICE).build(), MaterialBuilder.of("orange").rawColor(15763993).saturation(-0.1f).category(MaterialCategory.FRUIT).form(Form.JUICE).build(), MaterialBuilder.of("lemon").rawColor(15452747).saturation(-0.1f).category(MaterialCategory.FRUIT).form(Form.JUICE).build(), MaterialBuilder.of("grapefruit").rawColor(16011307).saturation(-0.1f).category(MaterialCategory.FRUIT).form(Form.JUICE).build(), MaterialBuilder.of("lime").rawColor(13294198).saturation(-0.1f).category(MaterialCategory.FRUIT).form(Form.JUICE).build(), new SimpleMaterialImpl("empowered_citron", 15120129, 0, 1, 1, 1, -0.1f, new MaterialCategory[]{MaterialCategory.FRUIT, MaterialCategory.SUPERNATURAL}){

            @Override
            public boolean hasGlowingOverlay(Ingredient ingredient) {
                return true;
            }
        }.setValidForms(Form.JUICE_ONLY)).forEach(api::register);
        api.register(new SimpleSpiceImpl("edible_oil", -1714313446, true, Collections.singleton("oil")));
        api.register(new SimpleSpiceImpl("sesame_oil", -1714518528, true, Collections.singleton("oil")));
        api.register(new SimpleSpiceImpl("soy_sauce", -586153984, true, Collections.singleton("sauce")));
        api.register(new SimpleSpiceImpl("rice_vinegar", -871366656, true, Collections.singleton("vinegar")));
        api.register(new SimpleSpiceImpl("fruit_vinegar", -1156579328, true, Collections.singleton("vinegar")));
        api.register(new SimpleSpiceImpl("water", 0x55FFFFFF, true, Collections.singleton("water")));
        api.register(new SpiceChiliPowder("chili_powder", 11546150));
        api.register(new SimpleSpiceImpl("sichuan_pepper_powder", 8606770, false, Collections.singleton("spicy")));
        api.register(new SimpleSpiceImpl("crude_salt", 4673362, false, (Set<String>)ImmutableSet.of((Object)"salt", (Object)"unrefined")));
        api.register(new SimpleSpiceImpl("salt", 0xE3E3E3, false, Collections.singleton("salt")));
        api.register(new SimpleSpiceImpl("sugar", 0xF9FFFE, false, Collections.singleton("sugar")));
        api.register(new SimpleSpiceImpl("unrefined_sugar", 11752448, false, (Set<String>)ImmutableSet.of((Object)"sugar", (Object)"unrefined")));
        CulinaryHub.CommonSkills.init();
    }

    public static void deferredInit() {
        CuisineInternalGateway api = INSTANCE;
        api.itemIngredients.put(ItemDefinition.of((Item)CuisineRegistry.CROPS, (int)ItemCrops.Variant.RED_PEPPER.getMeta()), new Ingredient(CulinaryHub.CommonMaterials.RED_PEPPER, Form.FULL));
        api.itemIngredients.put(ItemDefinition.of(CuisineRegistry.BASIC_FOOD, (int)ItemBasicFood.Variant.EMPOWERED_CITRON.getMeta()), new Ingredient(CulinaryHub.CommonMaterials.EMPOWERED_CITRON, Form.FULL));
        api.itemIngredients.put(ItemDefinition.of((Item)Items.field_151153_ao), new Ingredient(CulinaryHub.CommonMaterials.GOLDEN_APPLE, Form.FULL));
        api.itemIngredients.put(ItemDefinition.of((Item)Items.field_151153_ao, (int)1), new Ingredient(CulinaryHub.CommonMaterials.GOLDEN_APPLE_ENCHANTED, Form.FULL));
        api.itemIngredients.put(ItemDefinition.of((Item)Items.field_151127_ba), new Ingredient(CulinaryHub.CommonMaterials.MELON, Form.FULL));
        api.itemIngredients.put(ItemDefinition.of((Item)Items.field_151172_bF), new Ingredient(CulinaryHub.CommonMaterials.CARROT, Form.FULL));
        api.itemIngredients.put(ItemDefinition.of((Item)Items.field_151150_bK), new Ingredient(CulinaryHub.CommonMaterials.GOLDEN_CARROT, Form.FULL));
        api.itemIngredients.put(ItemDefinition.of((Item)Items.field_151174_bG), new Ingredient(CulinaryHub.CommonMaterials.POTATO, Form.FULL));
        api.itemIngredients.put(ItemDefinition.of((Item)Items.field_185164_cV), new Ingredient(CulinaryHub.CommonMaterials.BEETROOT, Form.FULL));
        api.itemIngredients.put(ItemDefinition.of((Item)Items.field_151115_aP), new Ingredient(CulinaryHub.CommonMaterials.FISH, Form.FULL));
        api.itemIngredients.put(ItemDefinition.of((Item)Items.field_151115_aP, (int)1), new Ingredient(CulinaryHub.CommonMaterials.FISH, Form.FULL));
        api.itemIngredients.put(ItemDefinition.of((Item)Items.field_151115_aP, (int)3), new Ingredient(CulinaryHub.CommonMaterials.PUFFERFISH, Form.FULL));
        api.oreDictIngredients.put("cropPeanut", new Ingredient(CulinaryHub.CommonMaterials.PEANUT, Form.FULL));
        api.oreDictIngredients.put("cropSesame", new Ingredient(CulinaryHub.CommonMaterials.SESAME, Form.FULL));
        api.oreDictIngredients.put("cropSoybean", new Ingredient(CulinaryHub.CommonMaterials.SOYBEAN, Form.FULL));
        api.oreDictIngredients.put("cropTomato", new Ingredient(CulinaryHub.CommonMaterials.TOMATO, Form.FULL));
        api.oreDictIngredients.put("cropChilipepper", new Ingredient(CulinaryHub.CommonMaterials.CHILI, Form.FULL));
        api.oreDictIngredients.put("foodRice", new Ingredient(CulinaryHub.CommonMaterials.RICE, Form.FULL));
        api.oreDictIngredients.put("cropGarlic", new Ingredient(CulinaryHub.CommonMaterials.GARLIC, Form.FULL));
        api.oreDictIngredients.put("cropGinger", new Ingredient(CulinaryHub.CommonMaterials.GINGER, Form.FULL));
        api.oreDictIngredients.put("cropSichuanpepper", new Ingredient(CulinaryHub.CommonMaterials.SICHUAN_PEPPER, Form.FULL));
        api.oreDictIngredients.put("cropScallion", new Ingredient(CulinaryHub.CommonMaterials.SCALLION, Form.FULL));
        api.oreDictIngredients.put("cropTurnip", new Ingredient(CulinaryHub.CommonMaterials.TURNIP, Form.FULL));
        api.oreDictIngredients.put("cropCabbage", new Ingredient(CulinaryHub.CommonMaterials.CHINESE_CABBAGE, Form.FULL));
        api.oreDictIngredients.put("cropLettuce", new Ingredient(CulinaryHub.CommonMaterials.LETTUCE, Form.FULL));
        api.oreDictIngredients.put("cropCorn", new Ingredient(CulinaryHub.CommonMaterials.CORN, Form.FULL));
        api.oreDictIngredients.put("cropCucumber", new Ingredient(CulinaryHub.CommonMaterials.CUCUMBER, Form.FULL));
        api.oreDictIngredients.put("cropLeek", new Ingredient(CulinaryHub.CommonMaterials.LEEK, Form.FULL));
        api.oreDictIngredients.put("cropOnion", new Ingredient(CulinaryHub.CommonMaterials.ONION, Form.FULL));
        api.oreDictIngredients.put("cropEggplant", new Ingredient(CulinaryHub.CommonMaterials.EGGPLANT, Form.FULL));
        api.oreDictIngredients.put("cropSpinach", new Ingredient(CulinaryHub.CommonMaterials.SPINACH, Form.FULL));
        api.oreDictIngredients.put("foodFirmtofu", new Ingredient(CulinaryHub.CommonMaterials.TOFU, Form.FULL));
        api.oreDictIngredients.put("cropChorusfruit", new Ingredient(CulinaryHub.CommonMaterials.CHORUS_FRUIT, Form.FULL));
        api.oreDictIngredients.put("cropApple", new Ingredient(CulinaryHub.CommonMaterials.APPLE, Form.FULL));
        api.oreDictIngredients.put("egg", new Ingredient(CulinaryHub.CommonMaterials.EGG, Form.FULL));
        api.oreDictIngredients.put("listAllporkraw", new Ingredient(CulinaryHub.CommonMaterials.PORK, Form.FULL));
        api.oreDictIngredients.put("listAllmuttonraw", new Ingredient(CulinaryHub.CommonMaterials.MUTTON, Form.FULL));
        api.oreDictIngredients.put("listAllbeefraw", new Ingredient(CulinaryHub.CommonMaterials.BEEF, Form.FULL));
        api.oreDictIngredients.put("listAllchickenraw", new Ingredient(CulinaryHub.CommonMaterials.CHICKEN, Form.FULL));
        api.oreDictIngredients.put("listAllrabbitraw", new Ingredient(CulinaryHub.CommonMaterials.RABBIT, Form.FULL));
        api.oreDictIngredients.put("blockCactus", new Ingredient(CulinaryHub.CommonMaterials.CACTUS, Form.FULL));
        api.oreDictIngredients.put("foodPickles", new Ingredient(CulinaryHub.CommonMaterials.PICKLED, Form.FULL));
        api.oreDictIngredients.put("cropMandarin", new Ingredient(CulinaryHub.CommonMaterials.MANDARIN, Form.FULL));
        api.oreDictIngredients.put("cropCitron", new Ingredient(CulinaryHub.CommonMaterials.CITRON, Form.FULL));
        api.oreDictIngredients.put("cropPomelo", new Ingredient(CulinaryHub.CommonMaterials.POMELO, Form.FULL));
        api.oreDictIngredients.put("cropOrange", new Ingredient(CulinaryHub.CommonMaterials.ORANGE, Form.FULL));
        api.oreDictIngredients.put("cropLemon", new Ingredient(CulinaryHub.CommonMaterials.LEMON, Form.FULL));
        api.oreDictIngredients.put("cropGrapefruit", new Ingredient(CulinaryHub.CommonMaterials.GRAPEFRUIT, Form.FULL));
        api.oreDictIngredients.put("cropLime", new Ingredient(CulinaryHub.CommonMaterials.LIME, Form.FULL));
        api.oreDictIngredients.put("cropBambooshoot", new Ingredient(CulinaryHub.CommonMaterials.BAMBOO_SHOOT, Form.FULL));
        api.oreDictIngredients.put("cropBellpepper", new Ingredient(CulinaryHub.CommonMaterials.GREEN_PEPPER, Form.FULL));
        api.oreDictIngredients.put("foodMushroom", new Ingredient(CulinaryHub.CommonMaterials.MUSHROOM, Form.FULL));
        api.oreDictIngredients.put("cropMushroom", new Ingredient(CulinaryHub.CommonMaterials.MUSHROOM, Form.FULL));
        api.oreDictIngredients.put("cropPumpkin", new Ingredient(CulinaryHub.CommonMaterials.PUMPKIN, Form.FULL));
        api.fluidIngredients.put(FluidRegistry.WATER.getName(), new Ingredient(CulinaryHub.CommonMaterials.WATER, Form.JUICE));
        api.fluidIngredients.put(CuisineFluids.MILK.getName(), new Ingredient(CulinaryHub.CommonMaterials.MILK, Form.JUICE));
        api.fluidIngredients.put(CuisineFluids.SOY_MILK.getName(), new Ingredient(CulinaryHub.CommonMaterials.SOY_MILK, Form.JUICE));
        api.fluidToSpiceMapping.put(CuisineFluids.EDIBLE_OIL.getName(), CulinaryHub.CommonSpices.EDIBLE_OIL);
        api.fluidToSpiceMapping.put(CuisineFluids.SESAME_OIL.getName(), CulinaryHub.CommonSpices.SESAME_OIL);
        api.fluidToSpiceMapping.put(CuisineFluids.SOY_SAUCE.getName(), CulinaryHub.CommonSpices.SOY_SAUCE);
        api.fluidToSpiceMapping.put(CuisineFluids.RICE_VINEGAR.getName(), CulinaryHub.CommonSpices.RICE_VINEGAR);
        api.fluidToSpiceMapping.put(CuisineFluids.FRUIT_VINEGAR.getName(), CulinaryHub.CommonSpices.FRUIT_VINEGAR);
        api.fluidToSpiceMapping.put(FluidRegistry.WATER.getName(), CulinaryHub.CommonSpices.WATER);
        api.itemToSpiceMapping.put(ItemDefinition.of((Item)CuisineRegistry.MATERIAL, (int)Cuisine.Materials.CHILI_POWDER.getMeta()), CulinaryHub.CommonSpices.CHILI_POWDER);
        api.itemToSpiceMapping.put(ItemDefinition.of((Item)CuisineRegistry.MATERIAL, (int)Cuisine.Materials.SICHUAN_PEPPER_POWDER.getMeta()), CulinaryHub.CommonSpices.SICHUAN_PEPPER_POWDER);
        api.itemToSpiceMapping.put(ItemDefinition.of((Item)Items.field_151102_aT), CulinaryHub.CommonSpices.SUGAR);
        api.itemToSpiceMapping.put(ItemDefinition.of((Item)CuisineRegistry.MATERIAL, (int)Cuisine.Materials.UNREFINED_SUGAR.getMeta()), CulinaryHub.CommonSpices.UNREFINED_SUGAR);
        api.oreDictToSpiceMapping.put("dustSalt", CulinaryHub.CommonSpices.SALT);
        api.oreDictToSpiceMapping.put("dustCrudesalt", CulinaryHub.CommonSpices.CRUDE_SALT);
    }

    @Override
    public void registerMapping(ItemDefinition item, Ingredient ingredient) {
        this.itemIngredients.put(item, ingredient);
    }

    @Override
    public void registerMapping(String ore, Ingredient ingredient) {
        this.oreDictIngredients.put(ore, ingredient);
    }

    @Override
    public void registerMapping(ItemDefinition item, Spice spice) {
        this.itemToSpiceMapping.put(item, spice);
    }

    @Override
    public void registerMapping(String ore, Spice spice) {
        this.oreDictToSpiceMapping.put(ore, spice);
    }

    @Override
    public Potion getEffectResistancePotion() {
        return CuisineRegistry.EFFECT_RESISTANCE;
    }

    @Override
    public FluidStack makeJuiceFluid(Material material, int amount) {
        return FluidJuice.make(material, amount);
    }
}

