/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.fluids;

import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import snownee.cuisine.fluids.BlockFluid;
import snownee.cuisine.fluids.BlockFluidOil;
import snownee.cuisine.fluids.BlockFluidSoyMilk;
import snownee.cuisine.fluids.BlockFluidVinegar;
import snownee.cuisine.fluids.FluidJuice;
import snownee.cuisine.fluids.FluidOil;
import snownee.cuisine.fluids.VaporizableFluid;

@Mod.EventBusSubscriber(modid="cuisine")
public class CuisineFluids {
    public static final Fluid SOY_MILK = new VaporizableFluid("soy_milk").setDensity(1001);
    public static final Fluid MILK = new VaporizableFluid("milk").setDensity(1001);
    public static final Fluid SOY_SAUCE = new Fluid("soy_sauce", new ResourceLocation("cuisine", "block/soy_sauce_still"), new ResourceLocation("cuisine", "block/soy_sauce_flow"));
    public static final Fluid RICE_VINEGAR = new VaporizableFluid("rice_vinegar").setDensity(1001).setColor(0x77FFFFAA);
    public static final Fluid FRUIT_VINEGAR = new VaporizableFluid("fruit_vinegar").setDensity(1001).setColor(-285212673);
    public static final Fluid SESAME_OIL = new FluidOil("sesame_oil");
    public static final Fluid EDIBLE_OIL = new FluidOil("edible_oil");
    public static final Fluid SUGARCANE_JUICE = new VaporizableFluid("sugarcane_juice").setDensity(1001);
    public static final Fluid JUICE = new FluidJuice("cuisine_juice");

    @SubscribeEvent
    public static void registerFluids(RegistryEvent.Register<Block> event) {
        FluidRegistry.registerFluid((Fluid)SOY_MILK);
        FluidRegistry.registerFluid((Fluid)MILK);
        FluidRegistry.registerFluid((Fluid)SOY_SAUCE);
        FluidRegistry.registerFluid((Fluid)RICE_VINEGAR);
        FluidRegistry.registerFluid((Fluid)FRUIT_VINEGAR);
        FluidRegistry.registerFluid((Fluid)SESAME_OIL);
        FluidRegistry.registerFluid((Fluid)EDIBLE_OIL);
        FluidRegistry.registerFluid((Fluid)SUGARCANE_JUICE);
        FluidRegistry.registerFluid((Fluid)JUICE);
        FluidRegistry.addBucketForFluid((Fluid)JUICE);
        BlockFluidSoyMilk soyMilkBlock = new BlockFluidSoyMilk(SOY_MILK);
        SOY_MILK.setBlock((Block)soyMilkBlock);
        BlockFluid milkBlock = new BlockFluid(MILK, "milk", new MaterialLiquid(MapColor.field_151666_j));
        MILK.setBlock((Block)milkBlock);
        BlockFluid soySauceBlock = new BlockFluid(SOY_SAUCE, "soy_sauce", new MaterialLiquid(MapColor.field_151650_B));
        SOY_SAUCE.setBlock((Block)soySauceBlock);
        BlockFluidVinegar riceVinegarBlock = new BlockFluidVinegar(RICE_VINEGAR, "rice_vinegar");
        RICE_VINEGAR.setBlock((Block)riceVinegarBlock);
        BlockFluidVinegar fruitVinegarBlock = new BlockFluidVinegar(FRUIT_VINEGAR, "fruit_vinegar");
        FRUIT_VINEGAR.setBlock((Block)fruitVinegarBlock);
        BlockFluidOil sesameOilBlock = new BlockFluidOil(SESAME_OIL, "sesame_oil");
        SESAME_OIL.setBlock((Block)sesameOilBlock);
        BlockFluidOil edibleOilBlock = new BlockFluidOil(EDIBLE_OIL, "edible_oil");
        EDIBLE_OIL.setBlock((Block)edibleOilBlock);
        BlockFluidOil sugarcaneJuiceBlock = new BlockFluidOil(SUGARCANE_JUICE, "sugarcane_juice");
        SUGARCANE_JUICE.setBlock((Block)sugarcaneJuiceBlock);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{soyMilkBlock, milkBlock, soySauceBlock, riceVinegarBlock, fruitVinegarBlock, sesameOilBlock, edibleOilBlock, sugarcaneJuiceBlock});
    }
}

