/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.fluids;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.fluids.BlockFluid;
import snownee.cuisine.fluids.CuisineFluidBlocks;

public class BlockFluidSoyMilk
extends BlockFluid {
    public BlockFluidSoyMilk(Fluid fluid) {
        super(fluid, "soy_milk", new MaterialLiquid(MapColor.field_151666_j));
        this.func_149675_a(true);
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighbourPos) {
        super.func_189540_a(state, world, pos, neighborBlock, neighbourPos);
        this.checkMixing(state, world, pos, neighbourPos);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockPos neighbourPos = pos.func_177972_a(side);
            this.checkMixing(state, world, pos, neighbourPos);
        }
    }

    public void checkMixing(@Nonnull IBlockState state, World world, BlockPos pos, @Nonnull BlockPos neighbourPos) {
        Block block = world.func_180495_p(neighbourPos).func_177230_c();
        if (this.isSourceBlock((IBlockAccess)world, pos) && (block == CuisineFluidBlocks.FRUIT_VINEGAR || block == CuisineFluidBlocks.RICE_VINEGAR)) {
            world.func_175656_a(pos, CuisineRegistry.TOFU_BLOCK.func_176223_P());
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!worldIn.field_72995_K) {
            if (entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).curePotionEffects(new ItemStack(Items.field_151117_aB));
            } else if ((Integer)state.func_177229_b((IProperty)LEVEL) == 0 && entityIn instanceof EntityItem) {
                EntityItem entityItem = (EntityItem)entityIn;
                if (entityItem.field_70128_L || entityItem.func_174874_s()) {
                    return;
                }
                ItemStack stack = entityItem.func_92059_d();
                if (stack.func_77973_b() == CuisineRegistry.MATERIAL && stack.func_77960_j() == Cuisine.Materials.CRUDE_SALT.getMeta()) {
                    stack.func_190918_g(1);
                    worldIn.func_175656_a(pos, CuisineRegistry.TOFU_BLOCK.func_176223_P());
                }
            }
        }
    }
}

