/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.fluids;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import snownee.cuisine.fluids.CuisineFluidBlocks;

public class BlockFluid
extends BlockFluidClassic {
    public BlockFluid(Fluid fluid, String name, MaterialLiquid material) {
        super(fluid, (Material)material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.setRegistryName("cuisine", name);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
    }

    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        AxisAlignedBB entityBox;
        AxisAlignedBB box = iblockstate.func_185900_c(world, blockpos).func_186670_a(blockpos);
        return box.func_72326_a(entityBox = entity.func_174813_aQ()) && materialIn.func_76224_d();
    }

    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        Block block = state.func_177230_c();
        if (block == CuisineFluidBlocks.SESAME_OIL) {
            return BlockFluid.getVecColor(13534720);
        }
        if (block == CuisineFluidBlocks.EDIBLE_OIL) {
            return BlockFluid.getVecColor(13739802);
        }
        if (block == CuisineFluidBlocks.SOY_MILK) {
            return BlockFluid.getVecColor(14538687);
        }
        if (block == CuisineFluidBlocks.MILK) {
            return BlockFluid.getVecColor(0xFFFFFF);
        }
        if (block == CuisineFluidBlocks.SUGARCANE_JUICE) {
            return BlockFluid.getVecColor(9342826);
        }
        if (block == CuisineFluidBlocks.SOY_SAUCE || block == CuisineFluidBlocks.FRUIT_VINEGAR || block == CuisineFluidBlocks.RICE_VINEGAR) {
            return BlockFluid.getVecColor(0x100000);
        }
        return super.getFogColor(world, pos, state, entity, originalColor, partialTicks);
    }

    protected static final Vec3d getVecColor(int color) {
        double r = (float)(color >> 16 & 0xFF) / 255.0f;
        double g = (float)(color >> 8 & 0xFF) / 255.0f;
        double b = (float)(color & 0xFF) / 255.0f;
        return new Vec3d(r, g, b);
    }
}

