/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.events;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.blocks.BlockCuisineCrops;
import snownee.cuisine.items.ItemBasicFood;
import snownee.cuisine.items.ItemCrops;
import snownee.cuisine.world.gen.WorldGenGarden;
import snownee.kiwi.util.definition.ItemDefinition;

@Mod.EventBusSubscriber(modid="cuisine")
public class VillagerHandler {
    @SubscribeEvent
    public static void onRegisterVillagers(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        VillagerRegistry.VillagerProfession profession = (VillagerRegistry.VillagerProfession)event.getRegistry().getValue(new ResourceLocation("minecraft:farmer"));
        if (profession == null) {
            return;
        }
        VillagerRegistry.VillagerCareer career = profession.getCareer(0);
        career.addTrade(3, new EntityVillager.ITradeList[]{new TradeCrops(ItemDefinition.of(CuisineRegistry.BASIC_FOOD, (int)ItemBasicFood.Variant.TOFU.getMeta()), 8)});
        career.addTrade(4, new EntityVillager.ITradeList[]{new TradeCrops(Arrays.asList(ItemDefinition.of((Item)CuisineRegistry.CROPS, (int)ItemCrops.Variant.CHILI.getMeta()), ItemDefinition.of((Item)CuisineRegistry.CROPS, (int)ItemCrops.Variant.GARLIC.getMeta())), 3)});
        List<ItemDefinition> crops = WorldGenGarden.PLANT_POOL.stream().filter(b -> b instanceof BlockCuisineCrops).map(b -> ((BlockCuisineCrops)((Object)b)).getCrop()).collect(Collectors.toList());
        career.addTrade(2, new EntityVillager.ITradeList[]{new TradeCrops(crops, -17)});
        career.addTrade(3, new EntityVillager.ITradeList[]{new TradeCrops(crops, -17)});
        career.addTrade(4, new EntityVillager.ITradeList[]{new TradeCrops(crops, -17)});
    }

    static class TradeCrops
    implements EntityVillager.ITradeList {
        private final List<ItemDefinition> stacks;
        private final int count;

        public TradeCrops(ItemDefinition stack, int count) {
            this(Collections.singletonList(stack), count);
        }

        public TradeCrops(List<ItemDefinition> stacks, int count) {
            this.stacks = stacks;
            this.count = count;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            if (this.stacks.size() <= 0) {
                return;
            }
            ItemStack stack = this.stacks.get(random.nextInt(this.stacks.size())).getItemStack();
            int i = Math.max(Math.abs(this.count), 3);
            i = i - 2 + random.nextInt(5);
            stack.func_190920_e(i);
            MerchantRecipe recipe = this.count > 0 ? new MerchantRecipe(new ItemStack(Items.field_151166_bC), stack) : new MerchantRecipe(stack, Items.field_151166_bC);
            recipeList.add((Object)recipe);
        }
    }
}

