/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.events;

import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.FoodContainer;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.MaterialCategory;
import snownee.cuisine.client.CulinaryRenderHelper;
import snownee.cuisine.library.RarityManager;

@Mod.EventBusSubscriber(modid="cuisine", value={Side.CLIENT})
public final class TooltipHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void makeTooltip(ItemTooltipEvent event) {
        if (!CuisineConfig.CLIENT.showTooltipIcons || event.getToolTip().isEmpty()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        int i = 0;
        if (stack.hasCapability(CulinaryCapabilities.FOOD_CONTAINER, null)) {
            CompositeFood composite;
            FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
            if (container == null || (composite = container.get()) == null) {
                return;
            }
            for (Ingredient ingredientIn : composite.getIngredients()) {
                i += ingredientIn.getMaterial().getCategories().size();
                if (!ingredientIn.getEffects().contains(CulinaryHub.CommonEffects.RARE)) continue;
                ++i;
            }
        } else {
            Ingredient ingredient = CulinaryHub.API_INSTANCE.findIngredient(stack);
            if (ingredient != null) {
                i = ingredient.getMaterial().getCategories().size();
                if (ingredient.getEffects().contains(CulinaryHub.CommonEffects.RARE)) {
                    ++i;
                }
            } else {
                return;
            }
        }
        if (i > 0) {
            i = Math.min(i, 12);
            StringBuilder string = new StringBuilder();
            for (int j = 0; j < i; ++j) {
                string.append("  ");
            }
            event.getToolTip().add(1, string.toString());
        }
    }

    @SubscribeEvent
    public static void renderTooltipRarity(RenderTooltipEvent.PostText event) {
        EnumRarity rarity;
        ItemStack stack = event.getStack();
        if (!stack.func_190926_b() && stack.func_77942_o() && (rarity = RarityManager.getRarity(stack)) != EnumRarity.COMMON) {
            int rgb = ItemDye.field_150922_c[rarity.field_77937_e.func_175746_b()];
            String name = stack.func_82833_r();
            if (stack.func_82837_s()) {
                name = TextFormatting.ITALIC + name;
            }
            Minecraft.func_71410_x().field_71466_p.func_175063_a(name, (float)event.getX(), (float)event.getY(), rgb);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderTooltip(RenderTooltipEvent.PostText event) {
        String line;
        if (!CuisineConfig.CLIENT.showTooltipIcons) {
            return;
        }
        List lines = event.getLines();
        if (lines.isEmpty()) {
            return;
        }
        ItemStack stack = event.getStack();
        int y = event.getY() + event.getFontRenderer().field_78288_b + 3;
        for (int i = 1; i < lines.size() && !(line = (String)lines.get(i)).trim().equals("\u00a77"); ++i) {
            if (i == lines.size() - 1) {
                return;
            }
            y += event.getFontRenderer().field_78288_b + 1;
        }
        int x = event.getX();
        if (stack.hasCapability(CulinaryCapabilities.FOOD_CONTAINER, null)) {
            CompositeFood composite;
            FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
            if (container == null || (composite = container.get()) == null) {
                return;
            }
            Object2DoubleArrayMap map = new Object2DoubleArrayMap();
            for (Ingredient ingredientIn : composite.getIngredients()) {
                for (MaterialCategory category : ingredientIn.getMaterial().getCategories()) {
                    map.put((Object)category, (Double)map.getOrDefault((Object)category, (Object)0.0) + 1.0);
                }
                if (!ingredientIn.getEffects().contains(CulinaryHub.CommonEffects.RARE)) continue;
                map.put((Object)MaterialCategory.UNKNOWN, (Double)map.getOrDefault((Object)MaterialCategory.UNKNOWN, (Object)0.0) + 1.0);
            }
            if (!map.isEmpty()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                CulinaryRenderHelper.renderMaterialCategoryIcons((Map<MaterialCategory, Double>)map, 0, 0, composite.getSaturationModifier(), event.getWidth() * 2 - 5);
                GlStateManager.func_179121_F();
            }
        } else {
            Ingredient ingredient = CulinaryHub.API_INSTANCE.findIngredient(stack);
            if (ingredient != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                Set<MaterialCategory> set = ingredient.getMaterial().getCategories();
                if (!set.isEmpty()) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                    GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                    Object2DoubleArrayMap map = new Object2DoubleArrayMap();
                    for (MaterialCategory category : set) {
                        map.put((Object)category, (Double)map.getOrDefault((Object)category, (Object)0.0) + 1.0);
                    }
                    if (ingredient.getEffects().contains(CulinaryHub.CommonEffects.RARE)) {
                        map.put((Object)MaterialCategory.UNKNOWN, (Double)map.getOrDefault((Object)MaterialCategory.UNKNOWN, (Object)0.0) + 1.0);
                    }
                    CulinaryRenderHelper.renderMaterialCategoryIcons((Map<MaterialCategory, Double>)map, 0, 0, 0.4f + ingredient.getMaterial().getSaturationModifier(ingredient), event.getWidth() * 2 - 5);
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179121_F();
            }
        }
    }
}

