/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.events;

import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.events.SpiceBottleContentConsumedEvent;
import snownee.cuisine.fluids.CuisineFluids;
import snownee.cuisine.internal.food.Drink;
import snownee.kiwi.item.IVariant;

@Mod.EventBusSubscriber(modid="cuisine")
public class SpiceBottleHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onSpiceBottleUsed(SpiceBottleContentConsumedEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (event.getContent().getClass() == FluidStack.class) {
            FluidStack stack = (FluidStack)event.getContent();
            String name = stack.getFluid().getName();
            if (name.equals("milk") || name.equals("soy_milk")) {
                entity.curePotionEffects(new ItemStack(Items.field_151117_aB));
                event.setCanceled(true);
            } else if (name.equals(CuisineFluids.SOY_SAUCE.getName()) || name.equals(CuisineFluids.EDIBLE_OIL.getName()) || name.equals(CuisineFluids.SESAME_OIL.getName())) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1200, 3));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 1200, 0));
                event.setCanceled(true);
            } else if (name.equals("quicksand")) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 6000, 5));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 6000, 5));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 6000, 0));
            } else if (name.equals("poison")) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 100));
                event.setCanceled(true);
            } else if (name.equals("hot_spring_water")) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 2400, 0));
                event.setCanceled(true);
            } else if (name.equals("honey")) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 2400, 1));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76443_y, 2400, 0));
                event.setCanceled(true);
            } else if (name.equals("blood")) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 1, 1));
                event.setCanceled(true);
            } else if (event.getEntityLiving() instanceof EntityPlayer) {
                Material material = CulinaryHub.API_INSTANCE.findMaterial(stack);
                if (material == null || !material.isValidForm(Form.JUICE)) {
                    return;
                }
                Drink.Builder builder = Drink.Builder.create();
                builder.addIngredient(null, new Ingredient(material, Form.JUICE), CuisineRegistry.BOTTLE);
                builder.addIngredient(null, new Ingredient(material, Form.JUICE), CuisineRegistry.BOTTLE);
                Optional<Drink> result = builder.build(CuisineRegistry.BOTTLE, null);
                if (!result.isPresent()) {
                    return;
                }
                result.get().onEaten(event.getItemStack(), event.getWorld(), (EntityPlayer)event.getEntityLiving());
                event.setCanceled(true);
            }
        } else if (event.getContent().getClass() == ItemStack.class) {
            ItemStack stack = (ItemStack)event.getContent();
            if (stack.func_77969_a(CuisineRegistry.MATERIAL.getItemStack((IVariant)Cuisine.Materials.CRUDE_SALT)) || stack.func_77969_a(CuisineRegistry.MATERIAL.getItemStack((IVariant)Cuisine.Materials.SALT))) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1200, 3));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 1200, 0));
                event.setCanceled(true);
            } else if (stack.func_77969_a(CuisineRegistry.MATERIAL.getItemStack((IVariant)Cuisine.Materials.CHILI_POWDER))) {
                if (!entity.func_70045_F()) {
                    entity.func_70015_d(60);
                    event.setCanceled(true);
                }
            } else if (stack.func_77969_a(CuisineRegistry.MATERIAL.getItemStack((IVariant)Cuisine.Materials.SICHUAN_PEPPER_POWDER))) {
                entity.func_70024_g(0.0, (double)(entity.field_70747_aH * 20.0f), 0.0);
                event.setCanceled(true);
            }
        }
    }
}

