/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.events;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.util.FoodStats;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.events.SkillPointUpdateEvent;
import snownee.cuisine.api.util.SkillUtil;
import snownee.cuisine.library.CuisineFoodStats;
import snownee.cuisine.network.PacketSkillLevelIncreased;
import snownee.kiwi.network.NetworkChannel;
import snownee.kiwi.network.PacketMod;

@Mod.EventBusSubscriber(modid="cuisine")
public class PlayerHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerSkillPointUpdate(SkillPointUpdateEvent event) {
        int oldLevel = SkillUtil.getLevel(event.getEntityPlayer(), event.getSkillPoint());
        int newLevel = SkillUtil.getLevel(event.getNewValue());
        if (newLevel > oldLevel) {
            NetworkChannel.INSTANCE.sendToPlayer((PacketMod)new PacketSkillLevelIncreased(event.getSkillPoint(), (short)oldLevel, (short)newLevel), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        if (CuisineConfig.HARDCORE.enable && CuisineConfig.HARDCORE.lowerFoodLevel && !Loader.isModLoaded((String)"applecore") && event.getEntity() instanceof EntityPlayer) {
            FoodStats oldFoodStats = ((EntityPlayer)event.getEntity()).field_71100_bB;
            CuisineFoodStats newFoodStats = new CuisineFoodStats();
            newFoodStats.field_75126_c = oldFoodStats.field_75126_c;
            newFoodStats.field_75125_b = oldFoodStats.field_75125_b;
            newFoodStats.field_75127_a = oldFoodStats.field_75127_a;
            newFoodStats.field_75123_d = oldFoodStats.field_75123_d;
            ((EntityPlayer)event.getEntity()).field_71100_bB = newFoodStats;
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        if (event.getEntityPlayer().func_70644_a((Potion)CuisineRegistry.COLD_BLOOD)) {
            event.setDamageModifier(event.getDamageModifier() * 2.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onKnockBack(LivingKnockBackEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70122_E && entity.func_70093_af() && entity.func_70644_a((Potion)CuisineRegistry.TOUGHNESS)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onProjectileImpact(LivingAttackEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70122_E && entity.func_70093_af() && event.getSource().func_76352_a() && entity.func_70644_a((Potion)CuisineRegistry.TOUGHNESS)) {
            event.setCanceled(true);
        }
    }
}

