/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.cuisine.CuisineRegistry;

@Mod.EventBusSubscriber(modid="cuisine")
public final class EntityBehaviorHandler {
    private static boolean dispersalEffectImpl(EntityLivingBase entity) {
        return entity != null && !entity.func_70662_br() && entity.func_70660_b((Potion)CuisineRegistry.DISPERSAL) != null;
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        EntityThrowable throwable;
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof EntityMob && ((EntityMob)event.getEntity()).func_70662_br()) {
            EntityMob mob = (EntityMob)event.getEntity();
            for (EntityAITasks.EntityAITaskEntry task : mob.field_70714_bg.field_75782_a) {
                if (!(task.field_75733_a instanceof EntityAIAvoidEntity) || ((EntityAIAvoidEntity)task.field_75733_a).field_181064_i != EntityLivingBase.class) continue;
                return;
            }
            mob.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)mob, EntityLivingBase.class, EntityBehaviorHandler::dispersalEffectImpl, 10.0f, 1.0, 1.2));
        } else if (event.getEntity() instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityLivingBase) {
                EntityBehaviorHandler.setFire((Entity)arrow, (EntityLivingBase)arrow.field_70250_c, 100);
            }
        } else if (event.getEntity() instanceof EntityThrowable && (throwable = (EntityThrowable)event.getEntity()).func_85052_h() != null) {
            EntityBehaviorHandler.setFire((Entity)throwable, throwable.func_85052_h(), 100);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingDamage(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        Entity entity = source.func_76346_g();
        if (!source.func_76352_a() && !source.func_82725_o() && entity instanceof EntityLivingBase) {
            EntityBehaviorHandler.setFire(event.getEntity(), (EntityLivingBase)entity, 3);
        }
    }

    private static void setFire(Entity projectile, EntityLivingBase shooter, int seconds) {
        PotionEffect effect = shooter.func_70660_b((Potion)CuisineRegistry.HOT);
        if (effect != null) {
            float rate = 0.4f + (float)effect.func_76458_c() * 0.2f;
            float random = shooter.func_130014_f_().field_73012_v.nextFloat();
            if (random < rate) {
                projectile.func_70015_d(seconds);
                if (random < rate * rate * rate) {
                    shooter.func_70015_d(3);
                }
            }
        }
    }
}

