/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.events;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.blocks.BlockCuisineCrops;
import snownee.cuisine.blocks.BlockDoubleCrops;
import snownee.cuisine.items.ItemCrops;
import snownee.kiwi.util.definition.ItemDefinition;

public class BetterHarvest {
    private static final Set<ResourceLocation> PASSING_ITEMS = Collections.singleton(new ResourceLocation("tconstruct", "scythe"));

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        if (!world.func_175660_a(player, pos)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        boolean isCrop = block instanceof BlockCrops && ((BlockCrops)block).func_185525_y(state);
        boolean bl = isCrop = isCrop || block instanceof BlockCuisineCrops && ((BlockCuisineCrops)block).isMaxAge(state, world, pos);
        if (isCrop) {
            if (Arrays.asList(CuisineConfig.GENERAL.betterHarvestBlacklist).contains(block.getRegistryName().toString())) {
                return;
            }
            if (!world.field_72995_K) {
                if (block instanceof BlockDoubleCrops && ((BlockDoubleCrops)block).isUpper(state)) {
                    pos = pos.func_177977_b();
                    state = world.func_180495_p(pos);
                    block = state.func_177230_c();
                }
                NonNullList drops = NonNullList.func_191196_a();
                block.getDrops(drops, (IBlockAccess)world, pos, state, 0);
                world.func_175698_g(pos);
                boolean fakeplayer = player instanceof FakePlayer && player.func_146103_bH().getName().equals("[IF]");
                ItemStack fallbackSeed = ItemStack.field_190927_a;
                ItemStack seed = ItemStack.field_190927_a;
                if (block instanceof BlockCrops && block == Blocks.field_150464_aj) {
                    fallbackSeed = block.func_185473_a(world, pos, state);
                }
                Iterator iterator = drops.iterator();
                while (iterator.hasNext()) {
                    ItemStack dropCandidate;
                    ItemStack drop = dropCandidate = (ItemStack)iterator.next();
                    if (!player.func_175151_a(pos, event.getFace(), drop)) continue;
                    if (block instanceof BlockCuisineCrops && ItemDefinition.of((ItemStack)drop).equals((Object)((BlockCuisineCrops)block).getSeed())) {
                        seed = drop;
                        break;
                    }
                    if (!(drop.func_77973_b() instanceof IPlantable)) continue;
                    if (block instanceof BlockCrops && drop.func_77969_a(block.func_185473_a(world, pos, state))) {
                        seed = block.func_185473_a(world, pos, state);
                        break;
                    }
                    fallbackSeed = drop;
                }
                if (seed.func_190926_b() && !fallbackSeed.func_190926_b()) {
                    seed = fallbackSeed;
                }
                if (!seed.func_190926_b()) {
                    BetterHarvest.plant(world, pos, player, seed);
                }
                for (ItemStack stack : drops) {
                    if (fakeplayer) {
                        player.func_191521_c(stack);
                        continue;
                    }
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
                }
            }
            if (!PASSING_ITEMS.contains(player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b().getRegistryName())) {
                event.setCancellationResult(EnumActionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    private static void plant(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        IBlockState state = stack.func_77973_b() instanceof ItemCrops ? ((ItemCrops.Variant)CuisineRegistry.CROPS.getVariants().get(stack.func_77960_j())).getValue().getBlock().func_176223_P() : ((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, pos);
        if (player instanceof EntityPlayerMP && world.func_180501_a(pos, state, 11)) {
            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
        }
        stack.func_190918_g(1);
    }
}

