/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.entities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import snownee.cuisine.Cuisine;
import snownee.cuisine.util.StacksUtil;

public class EntitySeed
extends EntityThrowable {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntityPotion.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntitySeed(World worldIn) {
        super(worldIn);
    }

    public EntitySeed(World worldIn, double x, double y, double z, ItemStack stack) {
        super(worldIn, x, y, z);
        this.setItem(stack);
    }

    public EntitySeed(World worldIn, EntityLivingBase throwerIn, ItemStack stack) {
        super(worldIn, throwerIn);
        this.setItem(stack);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    public void setItem(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
        this.func_184212_Q().func_187217_b(ITEM);
    }

    public ItemStack getItem() {
        ItemStack itemstack = (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
        if (itemstack.func_190926_b()) {
            if (this.field_70170_p != null) {
                Cuisine.logger.error("ThrownPotion entity {} has no item?!", (Object)this.func_145782_y());
            }
            return new ItemStack(Items.field_151014_N);
        }
        return itemstack;
    }

    public static void registerFixesPotion(DataFixer fixer) {
        EntityThrowable.func_189661_a((DataFixer)fixer, (String)"Item");
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackData(EntityPotion.class, new String[]{"Item"}));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        ItemStack itemstack = new ItemStack(compound.func_74775_l("Item"));
        if (itemstack.func_190926_b()) {
            this.func_70106_y();
        } else {
            this.setItem(itemstack);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        ItemStack itemstack = this.getItem();
        if (!itemstack.func_190926_b()) {
            compound.func_74782_a("Item", (NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.field_72308_g != null) {
            result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 4.0f);
        } else if (!this.field_70170_p.field_72995_K && this.func_85052_h() != null && this.func_85052_h() instanceof EntityPlayer && !((EntityPlayer)this.func_85052_h()).field_71075_bZ.field_75098_d && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            StacksUtil.spawnItemStack(this.field_70170_p, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c, this.getItem(), true);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }
}

