/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import snownee.kiwi.util.definition.ItemDefinition;

public final class WildcardIngredient
extends Ingredient {
    private final ItemDefinition definition;
    private ItemStack[] cachedMatchedInputs;
    private IntList cachedPackedMatchedInputs;

    private WildcardIngredient(ItemDefinition definition) {
        super(0);
        this.definition = definition;
    }

    public boolean apply(@Nullable ItemStack input) {
        return input != null && this.definition.matches(input);
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.cachedMatchedInputs == null) {
            NonNullList sink = NonNullList.func_191196_a();
            this.definition.getItem().func_150895_a(CreativeTabs.field_78027_g, sink);
            this.cachedMatchedInputs = (ItemStack[])sink.toArray((Object[])new ItemStack[0]);
            return this.cachedMatchedInputs;
        }
        return this.cachedMatchedInputs;
    }

    @Nonnull
    public IntList func_194139_b() {
        if (this.cachedPackedMatchedInputs == null) {
            this.cachedPackedMatchedInputs = new IntArrayList(Arrays.stream(this.func_193365_a()).mapToInt(RecipeItemHelper::func_194113_b).sorted().toArray());
            return this.cachedPackedMatchedInputs;
        }
        return this.cachedPackedMatchedInputs;
    }

    protected void invalidate() {
        this.cachedMatchedInputs = null;
        this.cachedPackedMatchedInputs = null;
    }

    public boolean isSimple() {
        return false;
    }

    public static final class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            String identifier = JsonUtils.func_151200_h((JsonObject)json, (String)"item");
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(identifier));
            if (item == null) {
                throw new JsonSyntaxException("Expect 'item' to be an item identifier, was unknown item identifier '" + identifier + "'");
            }
            int meta = JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0);
            return new WildcardIngredient(new ItemDefinition(item, meta));
        }
    }
}

