/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.crafting;

import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.items.ItemBasicFood;
import snownee.cuisine.library.DummyVanillaRecipe;
import snownee.kiwi.item.IVariant;

@Mod.EventBusSubscriber(modid="cuisine")
public final class VanillaRecipeRegistry {
    @SubscribeEvent
    public static void onVanillaRecipeRegistry(RegistryEvent.Register<IRecipe> event) {
        if (CuisineConfig.HARDCORE.enable) {
            ModContainer cuisineModContainer = Loader.instance().activeModContainer();
            Validate.isTrue((boolean)"cuisine".equals(((ModContainer)Validate.notNull((Object)cuisineModContainer)).getModId()));
            Loader.instance().setActiveModContainer((ModContainer)Loader.instance().getMinecraftModContainer());
            if (CuisineConfig.HARDCORE.harderSugarProduction) {
                ResourceLocation sugarRecipeName = new ResourceLocation("minecraft", "sugar");
                event.getRegistry().register((IForgeRegistryEntry)new DummyVanillaRecipe().setRegistryName(sugarRecipeName));
            }
            if (CuisineConfig.HARDCORE.harderBreadProduction) {
                ResourceLocation breadRecipeName = new ResourceLocation("minecraft", "bread");
                event.getRegistry().register((IForgeRegistryEntry)new DummyVanillaRecipe().setRegistryName(breadRecipeName));
            }
            if (CuisineConfig.HARDCORE.harderCookieProduction) {
                ResourceLocation cookieRecipeName = new ResourceLocation("minecraft", "cookie");
                event.getRegistry().register((IForgeRegistryEntry)new DummyVanillaRecipe().setRegistryName(cookieRecipeName));
            }
            Loader.instance().setActiveModContainer(cuisineModContainer);
        }
        GameRegistry.addSmelting((ItemStack)CuisineRegistry.BASIC_FOOD.getItemStack(ItemBasicFood.Variant.DOUGH), (ItemStack)new ItemStack(Items.field_151025_P), (float)0.35f);
        GameRegistry.addSmelting((Item)CuisineRegistry.IRON_SPATULA, (ItemStack)new ItemStack(Items.field_151042_j), (float)0.1f);
        GameRegistry.addSmelting((Item)CuisineRegistry.KITCHEN_KNIFE, (ItemStack)new ItemStack(Items.field_151042_j), (float)0.1f);
        GameRegistry.addSmelting((Item)CuisineRegistry.WOK, (ItemStack)new ItemStack(Items.field_151042_j, 3), (float)0.1f);
        GameRegistry.addSmelting((Block)CuisineRegistry.BAMBOO, (ItemStack)CuisineRegistry.MATERIAL.getItemStack((IVariant)Cuisine.Materials.BAMBOO_CHARCOAL), (float)0.1f);
        GameRegistry.addSmelting((Block)CuisineRegistry.LOG, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
    }

    @SubscribeEvent
    public static void getBurnTime(FurnaceFuelBurnTimeEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() == Item.func_150898_a((Block)CuisineRegistry.BAMBOO)) {
            event.setBurnTime(200);
        } else if (stack.func_77973_b() == Item.func_150898_a((Block)CuisineRegistry.SAPLING)) {
            event.setBurnTime(100);
        } else if (stack.func_77973_b() == CuisineRegistry.MATERIAL && stack.func_77952_i() == Cuisine.Materials.WOODEN_HANDLE.getMeta()) {
            event.setBurnTime(100);
        } else if (stack.func_77973_b() == CuisineRegistry.MATERIAL && stack.func_77952_i() == Cuisine.Materials.BAMBOO_CHARCOAL.getMeta()) {
            event.setBurnTime(1200);
        }
    }
}

