/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.crafting;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.MaterialCategory;
import snownee.cuisine.api.process.Chopping;
import snownee.cuisine.api.process.Grinding;
import snownee.cuisine.api.process.Milling;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.api.process.Vessel;
import snownee.cuisine.api.process.prefab.DistillationBoiling;
import snownee.cuisine.api.process.prefab.MaterialSqueezing;
import snownee.cuisine.api.process.prefab.SimpleSqueezing;
import snownee.cuisine.api.process.prefab.SimpleThrowing;
import snownee.cuisine.crafting.DrinkBrewingRecipe;
import snownee.cuisine.fluids.CuisineFluids;
import snownee.cuisine.fluids.FluidJuice;
import snownee.cuisine.items.ItemBasicFood;
import snownee.kiwi.crafting.input.ProcessingInput;
import snownee.kiwi.item.IVariant;
import snownee.kiwi.util.definition.ItemDefinition;
import snownee.kiwi.util.definition.OreDictDefinition;

public class RecipeRegistry {
    public static void postInit() {
        DrinkBrewingRecipe.add(CulinaryHub.CommonMaterials.CORN);
        DrinkBrewingRecipe.add(CulinaryHub.CommonMaterials.CUCUMBER);
        DrinkBrewingRecipe.add(CulinaryHub.CommonMaterials.TOMATO);
        DrinkBrewingRecipe.add(CulinaryHub.CommonMaterials.PUMPKIN);
        DrinkBrewingRecipe.add(CulinaryHub.CommonMaterials.GINGER);
    }

    public static void init() {
        if (CuisineConfig.GENERAL.axeChopping) {
            Processing.CHOPPING.add(new Chopping(new ResourceLocation("cuisine", "stick"), (ProcessingInput)OreDictDefinition.of((String)"plankWood"), new ItemStack(Items.field_151055_y, CuisineConfig.GENERAL.axeChoppingStickOutput)));
            Processing.CHOPPING.add(new Chopping(new ResourceLocation("cuisine", "oak"), (ProcessingInput)ItemDefinition.of((Block)Blocks.field_150364_r), new ItemStack(Blocks.field_150344_f, CuisineConfig.GENERAL.axeChoppingPlanksOutput)));
            Processing.CHOPPING.add(new Chopping(new ResourceLocation("cuisine", "spruce"), (ProcessingInput)ItemDefinition.of((Block)Blocks.field_150364_r, (int)1), new ItemStack(Blocks.field_150344_f, CuisineConfig.GENERAL.axeChoppingPlanksOutput, 1)));
            Processing.CHOPPING.add(new Chopping(new ResourceLocation("cuisine", "birch"), (ProcessingInput)ItemDefinition.of((Block)Blocks.field_150364_r, (int)2), new ItemStack(Blocks.field_150344_f, CuisineConfig.GENERAL.axeChoppingPlanksOutput, 2)));
            Processing.CHOPPING.add(new Chopping(new ResourceLocation("cuisine", "jungle"), (ProcessingInput)ItemDefinition.of((Block)Blocks.field_150364_r, (int)3), new ItemStack(Blocks.field_150344_f, CuisineConfig.GENERAL.axeChoppingPlanksOutput, 3)));
            Processing.CHOPPING.add(new Chopping(new ResourceLocation("cuisine", "acacia"), (ProcessingInput)ItemDefinition.of((Block)Blocks.field_150363_s), new ItemStack(Blocks.field_150344_f, CuisineConfig.GENERAL.axeChoppingPlanksOutput, 4)));
            Processing.CHOPPING.add(new Chopping(new ResourceLocation("cuisine", "dark_oak"), (ProcessingInput)ItemDefinition.of((Block)Blocks.field_150363_s, (int)1), new ItemStack(Blocks.field_150344_f, CuisineConfig.GENERAL.axeChoppingPlanksOutput, 5)));
            Processing.CHOPPING.add(new Chopping(new ResourceLocation("cuisine", "citrus"), (ProcessingInput)ItemDefinition.of((Block)CuisineRegistry.LOG), new ItemStack((Block)CuisineRegistry.PLANKS, CuisineConfig.GENERAL.axeChoppingPlanksOutput)));
        }
        Processing.GRINDING.add(new Grinding(new ResourceLocation("cuisine", "rice"), (List<ProcessingInput>)ImmutableList.of((Object)OreDictDefinition.of((String)"cropRice", (int)1)), CuisineRegistry.BASIC_FOOD.getItemStack(ItemBasicFood.Variant.WHITE_RICE), 4));
        Processing.GRINDING.add(new Grinding(new ResourceLocation("cuisine", "salt"), (List<ProcessingInput>)ImmutableList.of((Object)OreDictDefinition.of((String)"dustCrudesalt", (int)1)), CuisineRegistry.MATERIAL.getItemStack((IVariant)Cuisine.Materials.SALT), 10));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "chili_powder"), (ProcessingInput)OreDictDefinition.of((String)"cropChilipepper"), CuisineRegistry.MATERIAL.getItemStack((IVariant)Cuisine.Materials.CHILI_POWDER)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "sichuan_pepper_powder"), (ProcessingInput)OreDictDefinition.of((String)"cropSichuanpepper"), CuisineRegistry.MATERIAL.getItemStack((IVariant)Cuisine.Materials.SICHUAN_PEPPER_POWDER)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "flour"), new ItemStack(Items.field_151015_O), CuisineRegistry.BASIC_FOOD.getItemStack(ItemBasicFood.Variant.FLOUR)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "rice_powder"), (ProcessingInput)OreDictDefinition.of((String)"foodRice"), CuisineRegistry.BASIC_FOOD.getItemStack(ItemBasicFood.Variant.RICE_POWDER)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "salt"), (ProcessingInput)OreDictDefinition.of((String)"dustCrudesalt"), CuisineRegistry.MATERIAL.getItemStack((IVariant)Cuisine.Materials.SALT)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "sesame_oil"), (ProcessingInput)OreDictDefinition.of((String)"cropSesame"), ItemStack.field_190927_a, null, new FluidStack(CuisineFluids.SESAME_OIL, 20)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "oil_from_peanut"), (ProcessingInput)OreDictDefinition.of((String)"cropPeanut"), ItemStack.field_190927_a, null, new FluidStack(CuisineFluids.EDIBLE_OIL, 100)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "oil_from_rice"), (ProcessingInput)OreDictDefinition.of((String)"cropRice"), ItemStack.field_190927_a, null, new FluidStack(CuisineFluids.EDIBLE_OIL, 20)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "oil_from_rice_seed"), (ProcessingInput)OreDictDefinition.of((String)"seedRice"), ItemStack.field_190927_a, null, new FluidStack(CuisineFluids.EDIBLE_OIL, 20)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "oil_from_corn"), (ProcessingInput)OreDictDefinition.of((String)"cropCorn"), ItemStack.field_190927_a, null, new FluidStack(CuisineFluids.EDIBLE_OIL, 100)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "oil_from_beet_seed"), new ItemStack(Items.field_185163_cU), ItemStack.field_190927_a, null, new FluidStack(CuisineFluids.EDIBLE_OIL, 20)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "oil_from_melon_seed"), new ItemStack(Items.field_151081_bc), ItemStack.field_190927_a, null, new FluidStack(CuisineFluids.EDIBLE_OIL, 40)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "oil_from_pumpkin_seed"), new ItemStack(Items.field_151080_bb), ItemStack.field_190927_a, null, new FluidStack(CuisineFluids.EDIBLE_OIL, 40)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "oil_from_wheat_seed"), new ItemStack(Items.field_151014_N), ItemStack.field_190927_a, null, new FluidStack(CuisineFluids.EDIBLE_OIL, 20)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "soybean_milk"), (ProcessingInput)OreDictDefinition.of((String)"cropSoybean"), ItemStack.field_190927_a, new FluidStack(FluidRegistry.WATER, 100), new FluidStack(CuisineFluids.SOY_MILK, 100)));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "bonemeal"), (ProcessingInput)OreDictDefinition.of((String)"bone"), new ItemStack(Items.field_151100_aR, 4, 15), null, null));
        Processing.MILLING.add(new Milling(new ResourceLocation("cuisine", "prismarine_crystals"), new ItemStack(Items.field_179562_cC), new ItemStack(Items.field_179563_cD), null, null));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "vinegar_from_rice_powder"), (ProcessingInput)ItemDefinition.of(CuisineRegistry.BASIC_FOOD, (int)ItemBasicFood.Variant.RICE_POWDER.getMeta()), FluidRegistry.WATER, ItemDefinition.EMPTY, new FluidStack(CuisineFluids.RICE_VINEGAR, 20)));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "vinegar_from_rice"), (ProcessingInput)OreDictDefinition.of((String)"cropRice"), FluidRegistry.WATER, ItemDefinition.EMPTY, new FluidStack(CuisineFluids.RICE_VINEGAR, 30)));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "vinegar_from_rice_seed"), (ProcessingInput)OreDictDefinition.of((String)"foodRice"), FluidRegistry.WATER, ItemDefinition.EMPTY, new FluidStack(CuisineFluids.RICE_VINEGAR, 20)));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "pickled_pepper"), (ProcessingInput)OreDictDefinition.of((String)"cropChilipepper"), FluidRegistry.WATER, ItemDefinition.of(CuisineRegistry.BASIC_FOOD, (int)ItemBasicFood.Variant.PICKLED_PEPPER.getMeta()), null, (ProcessingInput)OreDictDefinition.of((String)"dustSalt")));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "pickled_cucumber"), (ProcessingInput)OreDictDefinition.of((String)"cropCucumber"), FluidRegistry.WATER, ItemDefinition.of(CuisineRegistry.BASIC_FOOD, (int)ItemBasicFood.Variant.PICKLED_CUCUMBER.getMeta()), null, (ProcessingInput)OreDictDefinition.of((String)"dustSalt")));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "pickled_cabbage"), (ProcessingInput)OreDictDefinition.of((String)"cropCabbage"), FluidRegistry.WATER, ItemDefinition.of(CuisineRegistry.BASIC_FOOD, (int)ItemBasicFood.Variant.PICKLED_CABBAGE.getMeta()), null, (ProcessingInput)OreDictDefinition.of((String)"dustSalt")));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "pickled_turnip"), (ProcessingInput)OreDictDefinition.of((String)"cropTurnip"), FluidRegistry.WATER, ItemDefinition.of(CuisineRegistry.BASIC_FOOD, (int)ItemBasicFood.Variant.PICKLED_TURNIP.getMeta()), null, (ProcessingInput)OreDictDefinition.of((String)"dustSalt")));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "soy_sauce"), (ProcessingInput)OreDictDefinition.of((String)"cropSoybean"), FluidRegistry.WATER, ItemDefinition.EMPTY, new FluidStack(CuisineFluids.SOY_SAUCE, 20)));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "vinegar_from_apple"), (ProcessingInput)ItemDefinition.of((Item)Items.field_151034_e), FluidRegistry.WATER, ItemDefinition.EMPTY, new FluidStack(CuisineFluids.FRUIT_VINEGAR, 10)));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "vinegar_from_golden_apple"), (ProcessingInput)ItemDefinition.of((Item)Items.field_151153_ao), FluidRegistry.WATER, ItemDefinition.EMPTY, new FluidStack(CuisineFluids.FRUIT_VINEGAR, 20)));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "vinegar_from_enchanted_apple"), (ProcessingInput)ItemDefinition.of((Item)Items.field_151153_ao, (int)1), FluidRegistry.WATER, ItemDefinition.EMPTY, new FluidStack(CuisineFluids.FRUIT_VINEGAR, 100)));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "vinegar_from_melon"), (ProcessingInput)ItemDefinition.of((Item)Items.field_151127_ba), FluidRegistry.WATER, ItemDefinition.EMPTY, new FluidStack(CuisineFluids.FRUIT_VINEGAR, 5)));
        Processing.VESSEL.add(new Vessel(new ResourceLocation("cuisine", "vinegar_from_melon_block"), (ProcessingInput)ItemDefinition.of((Block)Blocks.field_150440_ba), FluidRegistry.WATER, ItemDefinition.EMPTY, new FluidStack(CuisineFluids.FRUIT_VINEGAR, 50)));
        Processing.BOILING.add(new DistillationBoiling(new ResourceLocation("cuisine", "crude_salt"), new FluidStack(FluidRegistry.WATER, 200), CuisineRegistry.MATERIAL.getItemStack((IVariant)Cuisine.Materials.CRUDE_SALT), 0));
        Processing.BOILING.add(new DistillationBoiling(new ResourceLocation("cuisine", "unfined_sugar_from_sugarcane"), new FluidStack(CuisineFluids.SUGARCANE_JUICE, 200), CuisineRegistry.MATERIAL.getItemStack((IVariant)Cuisine.Materials.UNREFINED_SUGAR), 2));
        Processing.BOILING.add(new DistillationBoiling(new ResourceLocation("cuisine", "unfined_sugar_from_beet"), FluidJuice.make(CulinaryHub.CommonMaterials.BEETROOT, 200), CuisineRegistry.MATERIAL.getItemStack((IVariant)Cuisine.Materials.UNREFINED_SUGAR), 2));
        ItemStack sugar = new ItemStack(Items.field_151102_aT);
        Processing.BASIN_THROWING.add(new SimpleThrowing(new ResourceLocation("cuisine", "sugar_from_bamboo_and_sugarcane"), (ProcessingInput)ItemDefinition.of((Item)CuisineRegistry.MATERIAL, (int)Cuisine.Materials.BAMBOO_CHARCOAL.getMeta()), new FluidStack(CuisineFluids.SUGARCANE_JUICE, 200), sugar));
        Processing.BASIN_THROWING.add(new SimpleThrowing(new ResourceLocation("cuisine", "sugar_from_charcoal_and_sugarcane"), (ProcessingInput)ItemDefinition.of((Item)Items.field_151044_h, (int)1), new FluidStack(CuisineFluids.SUGARCANE_JUICE, 200), sugar));
        Processing.BASIN_THROWING.add(new SimpleThrowing(new ResourceLocation("cuisine", "sugar_from_bamboo_and_beet"), (ProcessingInput)ItemDefinition.of((Item)CuisineRegistry.MATERIAL, (int)Cuisine.Materials.BAMBOO_CHARCOAL.getMeta()), FluidJuice.make(CulinaryHub.CommonMaterials.BEETROOT, 200), sugar));
        Processing.BASIN_THROWING.add(new SimpleThrowing(new ResourceLocation("cuisine", "sugar_from_charcoal_and_beet"), (ProcessingInput)ItemDefinition.of((Item)Items.field_151044_h, (int)1), FluidJuice.make(CulinaryHub.CommonMaterials.BEETROOT, 200), sugar));
        if (CuisineConfig.GENERAL.basinConvertingConcrete) {
            FluidStack inputFluid = new FluidStack(FluidRegistry.WATER, 125);
            for (int i = 0; i < 16; ++i) {
                Processing.BASIN_THROWING.add(new SimpleThrowing(new ResourceLocation("cuisine", EnumDyeColor.func_176764_b((int)i).func_176610_l() + "_concrete"), (ProcessingInput)ItemDefinition.of((Block)Blocks.field_192444_dS, (int)i), inputFluid, new ItemStack(Blocks.field_192443_dR, 1, i)));
            }
        }
        Processing.SQUEEZING.add(new SimpleSqueezing(new ResourceLocation("cuisine", "sugarcane_squeezing"), (ProcessingInput)OreDictDefinition.of((String)"sugarcane"), new FluidStack(CuisineFluids.SUGARCANE_JUICE, 200)));
        CulinaryHub.API_INSTANCE.getKnownMaterials().stream().filter(m -> m.isValidForm(Form.JUICE)).filter(m -> m.isUnderCategoryOf(MaterialCategory.FRUIT) || m.isUnderCategoryOf(MaterialCategory.VEGETABLES) || m.isUnderCategoryOf(MaterialCategory.GRAIN)).forEach(m -> Processing.SQUEEZING.add(new MaterialSqueezing((Material)m)));
    }
}

