/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.crafting;

import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import snownee.cuisine.CuisineRegistry;
import snownee.kiwi.crafting.AbstractDynamicShapedRecipe;
import snownee.kiwi.util.OreUtil;

public class RecipeChoppingBoard
extends AbstractDynamicShapedRecipe {
    public ItemStack func_77572_b(InventoryCrafting inv) {
        for (int x = 0; x <= inv.func_174922_i() - this.getRecipeWidth(); ++x) {
            for (int y = 0; y <= inv.func_174923_h() - this.getRecipeHeight(); ++y) {
                if (!this.checkMatch(inv, x, y)) continue;
                return CuisineRegistry.CHOPPING_BOARD.getItemStack(inv.func_70463_b(x, y + 1));
            }
        }
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ret.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b().getToolClasses(stack).contains("axe")) {
                stack = stack.func_77946_l();
                stack.func_96631_a(1, new Random(), null);
                ret.set(i, (Object)stack);
                continue;
            }
            ret.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return ret;
    }

    public int getRecipeWidth() {
        return 1;
    }

    public int getRecipeHeight() {
        return 2;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY) {
        ItemStack axe = inv.func_70463_b(startX, startY);
        if (!axe.func_77973_b().getToolClasses(axe).contains("axe")) {
            return false;
        }
        ItemStack log = inv.func_70463_b(startX, startY + 1);
        if (!OreUtil.doesItemHaveOreName((ItemStack)log, (String)"logWood") || !(log.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        return this.checkEmpty(inv, startX, startY);
    }

    protected boolean checkEmpty(InventoryCrafting inv, int startX, int startY) {
        for (int x = 0; x < inv.func_174922_i(); ++x) {
            for (int y = 0; y < inv.func_174923_h(); ++y) {
                ItemStack stack;
                int subX = x - startX;
                int subY = y - startY;
                if (subX >= 0 && subY >= 0 && subX < this.getRecipeWidth() && subY < this.getRecipeHeight() || Ingredient.field_193370_a.apply(stack = inv.func_70463_b(x, y)) || stack.func_77973_b() == CuisineRegistry.KITCHEN_KNIFE) continue;
                return false;
            }
        }
        return true;
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return new RecipeChoppingBoard();
        }
    }
}

