/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.crafting;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.oredict.DyeUtils;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Material;
import snownee.kiwi.util.NBTHelper;

public class DrinkBrewingRecipe
implements IBrewingRecipe {
    public static final Set<String> BREWABLE_MATERIALS = new HashSet<String>();

    public static void add(Material material) {
        if (material.isValidForm(Form.JUICE)) {
            BREWABLE_MATERIALS.add(material.getID());
        }
    }

    public boolean isInput(ItemStack input) {
        if (input.func_77973_b() != CuisineRegistry.BOTTLE) {
            return false;
        }
        if (NBTHelper.of((ItemStack)input).hasTag("potion", 8)) {
            return true;
        }
        if (input.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem handler = (IFluidHandlerItem)input.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            FluidStack fluid = handler.drain(Integer.MAX_VALUE, false);
            if (fluid.tag != null && fluid.tag.func_150297_b("material", 8)) {
                return BREWABLE_MATERIALS.contains(fluid.tag.func_74779_i("material"));
            }
        }
        return false;
    }

    public boolean isIngredient(ItemStack ingredient) {
        return PotionHelper.func_185211_c((ItemStack)ingredient) || DyeUtils.isDye((ItemStack)ingredient);
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (!this.isInput(input) || !this.isIngredient(ingredient)) {
            return ItemStack.field_190927_a;
        }
        if (DyeUtils.isDye((ItemStack)ingredient)) {
            if (!NBTHelper.of((ItemStack)input).hasTag("potion", 8)) {
                return ItemStack.field_190927_a;
            }
            ItemStack output = input.func_77946_l();
            Optional result = DyeUtils.colorFromStack((ItemStack)ingredient);
            if (!result.isPresent()) {
                return ItemStack.field_190927_a;
            }
            int color = ((EnumDyeColor)result.get()).func_193350_e();
            NBTHelper helper = NBTHelper.of((ItemStack)output);
            if (helper.hasTag("liquidColor", 3)) {
                int colorBefore = helper.getInt("liquidColor", -1);
                color = Material.mixColor(colorBefore, color, 0.5f);
            }
            helper.setInt("liquidColor", color);
            return output;
        }
        ItemStack dummy = DrinkBrewingRecipe.makeDummyPotionItem(input);
        if (PotionHelper.func_185209_c((ItemStack)dummy, (ItemStack)ingredient)) {
            ItemStack dummyOutput = PotionHelper.func_185212_d((ItemStack)ingredient, (ItemStack)dummy);
            NBTHelper helper = NBTHelper.of((ItemStack)dummyOutput);
            if (!dummyOutput.func_190926_b() && helper.hasTag("Potion", 8)) {
                return NBTHelper.of((ItemStack)input.func_77946_l()).setString("potion", helper.getString("Potion", "empty")).getItem();
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack makeDummyPotionItem(ItemStack stack) {
        if (stack.func_77973_b() == CuisineRegistry.BOTTLE) {
            NBTHelper helper = NBTHelper.of((ItemStack)stack);
            if (helper.hasTag("potion", 8)) {
                ItemStack dummy = new ItemStack((Item)Items.field_151068_bn);
                return NBTHelper.of((ItemStack)dummy).setString("Potion", helper.getString("potion")).getItem();
            }
            return PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185233_e);
        }
        return ItemStack.field_190927_a;
    }
}

