/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.CulinarySkillPoint;
import snownee.cuisine.api.CulinarySkillPointContainer;
import snownee.cuisine.api.util.SkillUtil;
import snownee.cuisine.util.I18nUtil;

public class CommandSkill
extends CommandBase {
    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "culinaryskill";
    }

    public String func_71518_a(ICommandSender sender) {
        return I18nUtil.getFullKey("command.culinaryskill");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(args.length == 3 && (args[1].equalsIgnoreCase("get") || args[1].equalsIgnoreCase("getLevel")) || args.length == 4 && (args[1].equalsIgnoreCase("set") || args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("setLevel") || args[1].equalsIgnoreCase("addLevel")))) {
            throw new SyntaxErrorException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = CommandSkill.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        if (player == null) {
            throw new EntityNotFoundException(args[0]);
        }
        CulinarySkillPointContainer cap = (CulinarySkillPointContainer)player.getCapability(CulinaryCapabilities.CULINARY_SKILL, null);
        if (cap == null || cap.getAvailableSkillPoints().isEmpty()) {
            throw new EntityNotFoundException("Player does not have available skill.");
        }
        CulinarySkillPoint skillPoint = null;
        args[2] = args[2].toLowerCase(Locale.ROOT);
        for (CulinarySkillPoint point : cap.getAvailableSkillPoints()) {
            if (!point.toString().equals(args[2])) continue;
            skillPoint = point;
            break;
        }
        if (skillPoint == null) {
            throw new SyntaxErrorException("Unknown skill point.", new Object[0]);
        }
        try {
            switch (args[1].toLowerCase(Locale.ROOT)) {
                case "set": {
                    SkillUtil.setPoint((EntityPlayer)player, skillPoint, Integer.parseInt(args[3]));
                    break;
                }
                case "setlevel": {
                    SkillUtil.setLevel((EntityPlayer)player, skillPoint, Integer.parseInt(args[3]));
                    break;
                }
                case "add": {
                    SkillUtil.increasePoint((EntityPlayer)player, skillPoint, Integer.parseInt(args[3]));
                    break;
                }
                case "addlevel": {
                    SkillUtil.increaseLevel((EntityPlayer)player, skillPoint, Integer.parseInt(args[3]));
                    break;
                }
                case "get": {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("" + SkillUtil.getPoint((EntityPlayer)player, skillPoint), new Object[0]));
                    return;
                }
                case "getlevel": {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("" + SkillUtil.getLevel((EntityPlayer)player, skillPoint), new Object[0]));
                    return;
                }
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Success.", new Object[0]));
        }
        catch (IllegalArgumentException e) {
            throw new SyntaxErrorException("Illegal skill value", new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandSkill.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return CommandSkill.func_175762_a((String[])args, Arrays.asList("get", "getLevel", "set", "setLevel", "add", "addLevel"));
        }
        if (args.length == 3) {
            try {
                CulinarySkillPointContainer cap;
                EntityPlayerMP player = CommandSkill.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                if (player != null && (cap = (CulinarySkillPointContainer)player.getCapability(CulinaryCapabilities.CULINARY_SKILL, null)) != null) {
                    return CommandSkill.func_175762_a((String[])args, (Collection)cap.getAvailableSkillPoints().stream().map(CulinarySkillPoint::toString).collect(Collectors.toList()));
                }
            }
            catch (CommandException commandException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }
}

