/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.client.renderer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.client.CulinaryRenderHelper;
import snownee.cuisine.client.renderer.TESRFirePit;
import snownee.cuisine.fluids.CuisineFluids;
import snownee.cuisine.tiles.TileWok;

public class TESRWok
extends TESRFirePit<TileWok> {
    @Override
    public void render(TileWok tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TileWok.SeasoningInfo seasoningInfo;
        super.render(tile, x, y, z, partialTicks, destroyStage, alpha);
        Minecraft mc = Minecraft.func_71410_x();
        if (y > (double)mc.field_71439_g.eyeHeight) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        Map<Ingredient, ItemStack> contents = tile.getWokContents();
        if (!contents.isEmpty()) {
            GlStateManager.func_179094_E();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179137_b((double)0.5, (double)0.1, (double)0.5);
            int count = 0;
            for (Map.Entry<Ingredient, ItemStack> entry : contents.entrySet()) {
                GlStateManager.func_179094_E();
                ItemStack stack = entry.getValue();
                int seed = stack.hashCode() + tile.actionCycle * 439;
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                GlStateManager.func_179137_b((double)((double)(seed % 100 - 50) / 150.0), (double)(0.5 + (double)count / 1000.0), (double)((double)(seed % 56 - 28) / 84.0));
                GlStateManager.func_179114_b((float)((float)(360 * (seed % 943)) / 943.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                RenderHelper.func_74519_b();
                CulinaryRenderHelper.renderIngredient(mc, stack, entry.getKey().getDoneness());
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
                ++count;
            }
            GlStateManager.func_179121_F();
        }
        if ((seasoningInfo = tile.seasoningInfo) != null && seasoningInfo.volume > 0) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179094_E();
            RenderHelper.func_74518_a();
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            TextureAtlasSprite still = mc.func_147117_R().getTextureExtry(CuisineFluids.JUICE.getStill().toString());
            if (still == null) {
                still = mc.func_147117_R().func_174944_f();
            }
            int brightness = mc.field_71441_e.func_175626_b(tile.func_174877_v(), CuisineFluids.JUICE.getLuminosity());
            int lx = brightness >> 16 & 0xFFFF;
            int ly = brightness & 0xFFFF;
            int a = seasoningInfo.color >> 24 & 0xFF;
            int r = seasoningInfo.color >> 16 & 0xFF;
            int g = seasoningInfo.color >> 8 & 0xFF;
            int b = seasoningInfo.color & 0xFF;
            double height = 0.35 + (double)(MathHelper.func_76125_a((int)seasoningInfo.volume, (int)1, (int)10) * 200) / 18000.0;
            buffer.func_181662_b(0.0625, height, 0.0625).func_181669_b(r, g, b, a).func_187315_a((double)still.func_94209_e(), (double)still.func_94206_g()).func_187314_a(lx, ly).func_181675_d();
            buffer.func_181662_b(0.0625, height, 0.9375).func_181669_b(r, g, b, a).func_187315_a((double)still.func_94209_e(), (double)still.func_94210_h()).func_187314_a(lx, ly).func_181675_d();
            buffer.func_181662_b(0.9375, height, 0.9375).func_181669_b(r, g, b, a).func_187315_a((double)still.func_94212_f(), (double)still.func_94210_h()).func_187314_a(lx, ly).func_181675_d();
            buffer.func_181662_b(0.9375, height, 0.0625).func_181669_b(r, g, b, a).func_187315_a((double)still.func_94212_f(), (double)still.func_94206_g()).func_187314_a(lx, ly).func_181675_d();
            tessellator.func_78381_a();
            RenderHelper.func_74519_b();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    protected List<TESRFirePit.IngredientInfo> getIngredientInfo(TileWok tile) {
        Map<Ingredient, ItemStack> contents = tile.getWokContents();
        ArrayList<TESRFirePit.IngredientInfo> infos = new ArrayList<TESRFirePit.IngredientInfo>(contents.size());
        for (Map.Entry<Ingredient, ItemStack> entry : contents.entrySet()) {
            infos.add(new TESRFirePit.IngredientInfo(entry.getValue(), entry.getKey().getDoneness()));
        }
        return infos;
    }
}

