/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.client.renderer;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.client.CulinaryRenderHelper;
import snownee.cuisine.client.gui.CuisineGUI;
import snownee.cuisine.client.renderer.HoloProfiles;
import snownee.cuisine.tiles.TileFirePit;

public abstract class TESRFirePit<T extends TileFirePit>
extends TileEntitySpecialRenderer<T> {
    public void render(T tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int heat;
        boolean focusing;
        HoloProfiles.HoloProfile profile;
        float transparency;
        super.func_192841_a(tile, x, y, z, partialTicks, destroyStage, alpha);
        Minecraft mc = Minecraft.func_71410_x();
        if (CuisineConfig.CLIENT.showHoloGui && !mc.field_71474_y.field_74319_N && (transparency = (profile = HoloProfiles.get(tile)).update(focusing = mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && mc.field_71476_x.func_178782_a().equals((Object)tile.func_174877_v()), heat = (int)((TileFirePit)tile).getHeatHandler().getBurnTime(), partialTicks)) > 0.0f) {
            float offsetX;
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (transparency < 1.0f) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
            }
            GlStateManager.func_179094_E();
            double dx = x + 0.5;
            double dy = y + 0.5;
            double dz = z + 0.5;
            GlStateManager.func_179137_b((double)dx, (double)dy, (double)dz);
            float yaw = (float)(MathHelper.func_181159_b((double)dx, (double)dz) * 57.29577951308232);
            GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            double distance = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
            float pitch = (float)(MathHelper.func_181159_b((double)(y - 1.0), (double)distance) * -57.29577951308232);
            GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179140_f();
            List<IngredientInfo> infos = this.getIngredientInfo(tile);
            int width = 20;
            if (!infos.isEmpty()) {
                width += ((infos.size() - 1) / 3 + 1) * 20;
            }
            if (mc.field_71439_g.func_184591_cq() == EnumHandSide.RIGHT) {
                profile.extraWidth = HoloProfiles.HoloProfile.chase(profile.extraWidth, width, partialTicks / 10.0f * Math.abs(profile.extraWidth - (float)width));
                offsetX = -42.0f - profile.extraWidth;
            } else {
                offsetX = 42.0f;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            double scale = 0.011904761904761904;
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            GlStateManager.func_179109_b((float)offsetX, (float)-42.0f, (float)0.0f);
            mc.func_110434_K().func_110577_a(CuisineGUI.TEXTURE_ICONS);
            float height = ((float)heat - profile.minProgress) / (profile.maxProgress - profile.minProgress) * 78.0f + 1.0f;
            CulinaryRenderHelper.drawModalRect(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 80.0f - height, 256.0f, 256.0f);
            CulinaryRenderHelper.drawModalRect(0.0f, 80.0f - height, 8.0f, 80.0f - height, 8.0f, height, 256.0f, 256.0f);
            if (profile.icon0 < 0.0f) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((1.0f + profile.icon0 / 0.1f) * transparency));
            }
            CulinaryRenderHelper.drawModalRect(-4.0f, -10.0f + 80.0f * (1.0f - profile.icon0), 96.0f, 48.0f, 16.0f, 16.0f, 256.0f, 256.0f, 0.1f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
            if (profile.icon1 < 0.0f) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((1.0f + profile.icon1 / 0.1f) * transparency));
            }
            CulinaryRenderHelper.drawModalRect(-4.0f, -10.0f + 80.0f * (1.0f - profile.icon1), 112.0f, 48.0f, 16.0f, 16.0f, 256.0f, 256.0f, 0.2f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
            CulinaryRenderHelper.drawModalRect(-4.0f, -10.0f + 80.0f * (1.0f - profile.icon2), 128.0f, 48.0f, 16.0f, 16.0f, 256.0f, 256.0f, 0.3f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179141_d();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            scale = 0.16666666666666666;
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            scale = 0.07142857142857142;
            GlStateManager.func_179137_b((double)((double)(offsetX + 20.0f) * scale), (double)(42.0 * scale), (double)0.0);
            int yList = 0;
            int xList = 0;
            for (IngredientInfo info : infos) {
                GlStateManager.func_179090_x();
                GlStateManager.func_179140_f();
                if (info.doneness <= 100) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.6f * transparency));
                } else if (info.doneness < 150) {
                    float f = 1.0f - (float)(info.doneness - 110) / 50.0f;
                    GlStateManager.func_179131_c((float)1.0f, (float)f, (float)f, (float)(0.6f * transparency));
                } else {
                    GlStateManager.func_179131_c((float)1.0f, (float)0.2f, (float)0.2f, (float)(0.6f * transparency));
                }
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(9, DefaultVertexFormats.field_181705_e);
                double rad = 0.65;
                if (info.doneness < 100) {
                    buffer.func_181662_b((double)((float)xList * 1.5f), (double)(-1.5f + (float)yList * 1.5f), 0.0).func_181675_d();
                }
                for (float i = Math.min(1.0f, (float)info.doneness / 100.0f); i > 0.0f; i -= 0.04f) {
                    buffer.func_181662_b((double)((float)xList * 1.5f) + Math.sin((double)(i / 0.5f) * Math.PI) * rad, (double)(-1.5f + (float)yList * 1.5f) + Math.cos((double)(i / 0.5f) * Math.PI) * rad, 0.0).func_181675_d();
                }
                buffer.func_181662_b((double)((float)xList * 1.5f), (double)(-1.5f + (float)yList * 1.5f) + rad, 0.0).func_181675_d();
                if (info.doneness < 100) {
                    buffer.func_181662_b((double)((float)xList * 1.5f), (double)(-1.5f + (float)yList * 1.5f), 0.0).func_181675_d();
                }
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
                CulinaryRenderHelper.renderColoredItem(mc, info.stack, ItemCameraTransforms.TransformType.GUI, (int)(transparency * 255.0f) << 24 | 0xFFFFFF, (float)xList * 1.5f, -1.5f + (float)yList * 1.5f);
                if (--yList >= -2) continue;
                yList = 0;
                ++xList;
            }
            GlStateManager.func_179118_c();
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
    }

    protected abstract List<IngredientInfo> getIngredientInfo(T var1);

    protected static class IngredientInfo {
        ItemStack stack;
        int doneness;

        public IngredientInfo(ItemStack stack, int doneness) {
            this.stack = stack;
            this.doneness = doneness;
        }
    }
}

