/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.client.renderer;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="cuisine", value={Side.CLIENT})
public class HoloProfiles {
    public static final Int2ObjectOpenHashMap<HoloProfile> PROFILES = new Int2ObjectOpenHashMap();
    public static BlockPos focusingPos = BlockPos.field_177992_a;

    public static HoloProfile get(TileEntity tile) {
        HoloProfile hp = (HoloProfile)PROFILES.get(tile.func_174877_v().hashCode());
        if (hp == null) {
            hp = new HoloProfile(tile.func_174877_v());
            PROFILES.put(tile.func_174877_v().hashCode(), (Object)hp);
        }
        return hp;
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        PROFILES.remove(event.getPos().hashCode());
    }

    @SubscribeEvent
    public static void joinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            PROFILES.clear();
        }
    }

    public static class HoloProfile {
        public final BlockPos pos;
        public float alpha;
        public float icon0;
        public float icon1;
        public float icon2;
        public float minProgress;
        public float maxProgress;
        public float extraWidth;

        public HoloProfile(BlockPos pos) {
            this.pos = pos;
            this.icon0 = 0.0f;
            this.icon1 = 0.8f;
            this.icon2 = 0.8f;
        }

        public float update(boolean focusing, int heat, float partialTicks) {
            float targetMax;
            float targetMin;
            if (focusing) {
                focusingPos = this.pos;
            } else if (focusingPos.equals((Object)this.pos)) {
                focusingPos = BlockPos.field_177992_a;
            }
            int level = 0;
            if (heat > 0) {
                level = heat / 1000 + 1;
            }
            float target0 = 0.05f;
            if (level > 0) {
                target0 = level == 1 ? 0.0f : -0.1f;
            }
            float target1 = 0.8f;
            if (level > 1) {
                target1 = level == 2 ? 0.0f : -0.1f;
            }
            float target2 = 1.0f;
            if (level > 1) {
                target2 = level == 3 ? 0.0f : 0.8f;
            }
            float delta = partialTicks / 20.0f;
            this.icon0 = HoloProfile.chase(this.icon0, target0, delta * Math.abs(target0 - this.icon0));
            this.icon1 = HoloProfile.chase(this.icon1, target1, delta * Math.abs(target1 - this.icon1));
            this.icon2 = HoloProfile.chase(this.icon2, target2, delta * Math.abs(target2 - this.icon2));
            if (level < 2) {
                targetMin = 0.0f;
                targetMax = 1200.0f;
            } else if (level == 2) {
                targetMin = 1000.0f;
                targetMax = 2200.0f;
            } else {
                targetMin = 2000.0f;
                targetMax = 3000.0f;
            }
            this.minProgress = HoloProfile.chase(this.minProgress, targetMin, delta * Math.abs(targetMin - this.minProgress));
            this.maxProgress = HoloProfile.chase(this.maxProgress, targetMax, delta * Math.abs(targetMax - this.maxProgress));
            this.alpha = HoloProfile.chase(this.alpha, focusing ? 1.0f : 0.0f, delta * 2.0f);
            return this.alpha;
        }

        public static float chase(float raw, float target, float delta) {
            if (target == raw) {
                return target;
            }
            float min = Math.min(raw, target);
            float max = Math.max(raw, target);
            return MathHelper.func_76131_a((float)(raw + (target > raw ? delta : -delta)), (float)min, (float)max);
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public boolean equals(Object obj) {
            return this.pos.equals(obj);
        }
    }
}

