/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.client.model;

import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.TRSRTransformation;

final class TRSRBasedQuadTransformer
extends VertexTransformer {
    private final Matrix4f transformation;
    private final Matrix3f normalTransformation;

    TRSRBasedQuadTransformer(TRSRTransformation transform, VertexFormat vertexFormat) {
        super((IVertexConsumer)new UnpackedBakedQuad.Builder(vertexFormat));
        this.transformation = transform.getMatrix();
        this.normalTransformation = new Matrix3f();
        this.transformation.getRotationScale(this.normalTransformation);
        this.normalTransformation.invert();
        this.normalTransformation.transpose();
    }

    public void put(int element, float ... data) {
        VertexFormatElement.EnumUsage usage = this.parent.getVertexFormat().func_177348_c(element).func_177375_c();
        if (usage == VertexFormatElement.EnumUsage.POSITION && data.length >= 3) {
            Vector4f vec = new Vector4f(data[0], data[1], data[2], 1.0f);
            this.transformation.transform((Tuple4f)vec);
            data = new float[4];
            vec.get(data);
        } else if (usage == VertexFormatElement.EnumUsage.NORMAL && data.length >= 3) {
            Vector3f vec = new Vector3f(data);
            this.normalTransformation.transform((Tuple3f)vec);
            vec.normalize();
            data = new float[4];
            vec.get(data);
        }
        super.put(element, data);
    }

    public UnpackedBakedQuad build() {
        return ((UnpackedBakedQuad.Builder)this.parent).build();
    }
}

