/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import snownee.cuisine.client.model.ChoppingBoardModel;
import snownee.kiwi.util.NBTHelper;

public final class ChoppingBoardOverride
extends ItemOverrideList
implements ISelectiveResourceReloadListener {
    static final ChoppingBoardOverride INSTANCE = new ChoppingBoardOverride();
    static final TRSRTransformation CHOPPING_BOARD_SCALE_DOWN = new TRSRTransformation(new Vector3f(0.0f, -0.38f, 0.0f), null, new Vector3f(0.75f, 0.25f, 0.75f), null);
    private static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> CHOPPING_BOARD_TRANSFORMS;
    private final Cache<ItemStack, IBakedModel> modelCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite(300L, TimeUnit.SECONDS).weakKeys().build();

    private static TRSRTransformation of(float tx, float ty, float tz, float ax, float ay, float az, float scale) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(scale, scale, scale), null);
    }

    private ChoppingBoardOverride() {
        super(Collections.emptyList());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
        try {
            return (IBakedModel)this.modelCache.get((Object)stack, () -> this.getChoppingBoardModel(stack, world, entity));
        }
        catch (ExecutionException e) {
            return originalModel;
        }
    }

    private IBakedModel getChoppingBoardModel(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
        NBTHelper helper = NBTHelper.of((ItemStack)stack);
        IBakedModel rawModel = helper.hasTag("BlockEntityTag.cover", 10) ? ChoppingBoardModel.ModelResolver.tryGetFor(new ItemStack(helper.getTag("BlockEntityTag.cover")), world, entity) : Minecraft.func_71410_x().func_175602_ab().func_184389_a(Blocks.field_150364_r.func_176223_P());
        return new PerspectiveMapWrapper(rawModel, CHOPPING_BOARD_TRANSFORMS);
    }

    public ImmutableList<ItemOverride> getOverrides() {
        return ImmutableList.of();
    }

    public void onResourceManagerReload(IResourceManager manager, Predicate<IResourceType> predicate) {
        if (predicate.test((IResourceType)VanillaResourceType.TEXTURES) || predicate.test((IResourceType)VanillaResourceType.MODELS)) {
            this.modelCache.invalidateAll();
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            Class<?> v1Transform = Class.forName("net.minecraftforge.client.model.ForgeBlockStateV1$Transforms");
            Method getter = v1Transform.getDeclaredMethod("get", String.class);
            Optional defaultBlockTransform = (Optional)getter.invoke(null, "forge:default-block");
            if (defaultBlockTransform.isPresent()) {
                IModelState modelState = (IModelState)defaultBlockTransform.get();
                TRSRTransformation extraTransform = TRSRTransformation.blockCenterToCorner((TRSRTransformation)CHOPPING_BOARD_SCALE_DOWN);
                for (ItemCameraTransforms.TransformType transformType : ItemCameraTransforms.TransformType.values()) {
                    Optional result = modelState.apply(Optional.of(transformType));
                    if (!result.isPresent()) continue;
                    TRSRTransformation actualTransform = (TRSRTransformation)result.get();
                    builder.put((Object)transformType, (Object)actualTransform.compose(extraTransform));
                }
            }
        }
        catch (Throwable e) {
            builder = ImmutableMap.builder();
            builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)ChoppingBoardOverride.of(0.0f, 0.0f, 0.0f, 30.0f, 45.0f, 0.0f, 0.625f).compose(CHOPPING_BOARD_SCALE_DOWN))).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)ChoppingBoardOverride.of(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f).compose(CHOPPING_BOARD_SCALE_DOWN))).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)ChoppingBoardOverride.of(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f).compose(CHOPPING_BOARD_SCALE_DOWN))).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)ChoppingBoardOverride.of(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f).compose(CHOPPING_BOARD_SCALE_DOWN))).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)ChoppingBoardOverride.of(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f).compose(CHOPPING_BOARD_SCALE_DOWN))).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)ChoppingBoardOverride.of(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f).compose(CHOPPING_BOARD_SCALE_DOWN))).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)ChoppingBoardOverride.of(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f).compose(CHOPPING_BOARD_SCALE_DOWN)));
        }
        CHOPPING_BOARD_TRANSFORMS = builder.build();
    }
}

