/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.client.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.blocks.BlockChoppingBoard;
import snownee.cuisine.client.model.ChoppingBoardOverride;
import snownee.cuisine.client.model.TRSRBasedQuadTransformer;

public final class ChoppingBoardModel
implements IModel {
    static List<Item> useBlockModelFirst = Collections.emptyList();
    private boolean ambientOcclusion;
    private boolean gui3D;

    public static void updateSpecialItemList(String[] itemList) {
        useBlockModelFirst = Arrays.stream(itemList).map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ChoppingBoardModel() {
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite particleTexture = bakedTextureGetter.apply(new ResourceLocation("blocks/log_oak_top"));
        return new Baked(this.ambientOcclusion, this.gui3D, particleTexture);
    }

    public IModel smoothLighting(boolean value) {
        this.ambientOcclusion = value;
        return this;
    }

    public IModel gui3d(boolean value) {
        this.gui3D = value;
        return this;
    }

    static {
        ModelResolver.resolvers.add((stack, world, entity) -> {
            boolean found = false;
            for (Item i : useBlockModelFirst) {
                if (i != stack.func_77973_b()) continue;
                found = true;
                break;
            }
            if (found) {
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                return Minecraft.func_71410_x().func_175602_ab().func_184389_a(block.func_176223_P());
            }
            return null;
        });
        ChoppingBoardModel.updateSpecialItemList(CuisineConfig.CLIENT.useBlockModelForChoppingBoardFirst);
        ModelResolver.resolvers.add((stack, world, entity) -> Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, world, entity));
    }

    private static final class Baked
    implements IBakedModel {
        private static final TRSRTransformation TRANSFORM = TRSRTransformation.blockCenterToCorner((TRSRTransformation)ChoppingBoardOverride.CHOPPING_BOARD_SCALE_DOWN);
        private final boolean ambientOcclusion;
        private final boolean gui3D;
        private final TextureAtlasSprite particleTexture;

        Baked(boolean ambientOcclusion, boolean gui3D, TextureAtlasSprite particleTexture) {
            this.ambientOcclusion = ambientOcclusion;
            this.gui3D = gui3D;
            this.particleTexture = particleTexture;
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (state instanceof IExtendedBlockState) {
                List quads;
                ItemStack cover = (ItemStack)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockChoppingBoard.COVER_KEY);
                if (cover.func_190926_b()) {
                    return Collections.emptyList();
                }
                IBakedModel coverModel = ModelResolver.tryGetFor(cover, null, null);
                try {
                    quads = coverModel.func_188616_a(null, side, rand);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
                if (coverModel.func_188618_c()) {
                    return quads;
                }
                ArrayList<BakedQuad> transformedQuads = new ArrayList<BakedQuad>();
                for (BakedQuad quad : quads) {
                    TRSRBasedQuadTransformer transformer = new TRSRBasedQuadTransformer(TRANSFORM, quad.getFormat());
                    quad.pipe((IVertexConsumer)transformer);
                    transformedQuads.add((BakedQuad)transformer.build());
                }
                return transformedQuads;
            }
            return Collections.emptyList();
        }

        public boolean func_177555_b() {
            return this.ambientOcclusion;
        }

        public boolean func_177556_c() {
            return this.gui3D;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particleTexture;
        }

        public ItemOverrideList func_188617_f() {
            return ChoppingBoardOverride.INSTANCE;
        }
    }

    @FunctionalInterface
    public static interface ModelResolver {
        public static final Queue<ModelResolver> resolvers = new ArrayDeque<ModelResolver>();

        @Nullable
        public IBakedModel resolve(ItemStack var1, @Nullable World var2, @Nullable EntityLivingBase var3);

        public static IBakedModel tryGetFor(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            for (ModelResolver resolver : resolvers) {
                IBakedModel model = resolver.resolve(stack, world, entity);
                if (model == null) continue;
                return model;
            }
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
        }
    }

    public static final class Loader
    implements ICustomModelLoader {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void func_110549_a(IResourceManager manager) {
        }

        public boolean accepts(ResourceLocation location) {
            return "cuisine".equals(location.func_110624_b()) && "models/block/chopping_board_special".equals(location.func_110623_a());
        }

        public IModel loadModel(ResourceLocation location) {
            return new ChoppingBoardModel();
        }
    }
}

