/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.client.gui;

import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CulinarySkill;
import snownee.cuisine.api.CulinarySkillPoint;
import snownee.cuisine.util.I18nUtil;

@SideOnly(value=Side.CLIENT)
public class SkillToast
implements IToast {
    private final CulinarySkillPoint skillPoint;
    private final int level;
    private final String skills;
    private final boolean noSkill;

    public SkillToast(CulinarySkillPoint skillPoint, short level, Set<CulinarySkill> skills) {
        this.skillPoint = skillPoint;
        this.level = level;
        this.noSkill = skills.isEmpty();
        this.skills = skills.stream().map(CulinarySkill::getTranslationKey).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).collect(Collectors.joining(" "));
    }

    public IToast.Visibility func_193653_a(GuiToast toastGui, long delta) {
        toastGui.func_192989_b().func_110434_K().func_110577_a(field_193654_a);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        toastGui.func_73729_b(0, 0, 0, 32, 160, 32);
        if (delta < 3000L) {
            toastGui.func_192989_b().field_71466_p.func_78276_b(I18nUtil.translate("toast.skill.upgrade"), 10, 7, -11534256);
            toastGui.func_192989_b().field_71466_p.func_78276_b(I18nUtil.translate("toast.skill.description", I18nUtil.translate("skillpoint." + this.skillPoint.toString()), this.level), 10, 18, -16777216);
        }
        if (delta > 2000L && this.noSkill) {
            return IToast.Visibility.HIDE;
        }
        if (delta > 2000L && delta < 3000L) {
            int height = 24;
            double rad = Math.sin((double)(delta - 2000L) / 2000.0 * Math.PI) * 152.0;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179090_x();
            GlStateManager.func_179129_p();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_ALPHA);
            bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181705_e);
            bufferbuilder.func_181662_b(4.0, 4.0, 0.0).func_181675_d();
            for (int i = 0; i <= 20; ++i) {
                double y = Math.sin((double)((float)i / 40.0f) * Math.PI) * rad;
                if (!(y < 24.0)) {
                    bufferbuilder.func_181662_b(4.0 + Math.sqrt(rad * rad - 576.0), 28.0, 0.0).func_181675_d();
                    bufferbuilder.func_181662_b(4.0, 28.0, 0.0).func_181675_d();
                    break;
                }
                bufferbuilder.func_181662_b(4.0 + Math.cos((double)((float)i / 40.0f) * Math.PI) * rad, 4.0 + y, 0.0).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
        } else if (delta >= 3000L) {
            Gui.func_73734_a((int)4, (int)4, (int)156, (int)28, (int)-1);
        }
        if (delta > 2600L && !this.noSkill) {
            GlStateManager.func_179094_E();
            toastGui.func_192989_b().field_71466_p.func_78276_b(I18nUtil.translate("toast.skill.get"), 30, 7, -11534256);
            toastGui.func_192989_b().field_71466_p.func_78276_b(this.skills, 30, 18, -16777216);
            RenderHelper.func_74520_c();
            toastGui.func_192989_b().func_175599_af().func_180450_b(new ItemStack((Item)CuisineRegistry.KITCHEN_KNIFE), 8, 8);
            GlStateManager.func_179121_F();
        }
        return delta >= 5000L ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
    }
}

