/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.client.gui;

import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.util.ResourceLocation;
import snownee.cuisine.Cuisine;
import snownee.cuisine.util.I18nUtil;
import snownee.kiwi.client.AdvancedFontRenderer;
import snownee.kiwi.client.FontUtil;
import snownee.kiwi.client.gui.element.DrawableResource;

public class GuiManual
extends GuiScreen {
    private static final ResourceLocation BOOK_GUI_TEXTURES = new ResourceLocation("cuisine", "textures/gui/patchouli.png");
    private static int PAGE_HEIGHT = 180;
    private static int PAGE_WIDTH = 272;
    private static int PAGE_MARGIN = 20;
    private DrawableResource pageGrid;
    private final String chatRoomURL;
    private final String mcmodWikiURL;
    private final String text = I18nUtil.translateWithEscape("gui.welcome", new Object[0]);

    public GuiManual() {
        this.pageGrid = new DrawableResource(BOOK_GUI_TEXTURES, 0, 0, PAGE_WIDTH, PAGE_HEIGHT, 0, 0, 0, 0, 512, 256);
        if (Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a().startsWith("zh")) {
            this.chatRoomURL = "https://jq.qq.com/?_wv=1027&k=5GXZnpl";
            this.mcmodWikiURL = "https://www.mcmod.cn/class/1291.html";
        } else {
            this.chatRoomURL = "https://discord.gg/KzGQW7a";
            this.mcmodWikiURL = "";
        }
    }

    public void func_73866_w_() {
        this.field_146289_q = AdvancedFontRenderer.INSTANCE;
        this.field_146292_n.clear();
        this.func_189646_b(new GuiButton(0, (this.field_146294_l + PAGE_WIDTH / 2 - 90) / 2, (this.field_146295_m - 20) / 2, 80, 20, I18nUtil.translate("gui.openLink")));
        this.func_189646_b(new GuiButton(1, (this.field_146294_l + PAGE_WIDTH / 2 - 90) / 2, (this.field_146295_m - 20) / 2 + 40, 80, 20, I18nUtil.translate("gui.close")));
        if (this.field_146297_k.func_135016_M().func_135041_c().func_135034_a().startsWith("zh")) {
            this.func_189646_b(new GuiButton(2, (this.field_146294_l + PAGE_WIDTH / 2 - 90) / 2, (this.field_146295_m - 20) / 2 - 40, 80, 20, I18nUtil.translate("gui.openWiki")));
        }
    }

    public void func_146281_b() {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.field_146297_k.func_110434_K().func_110577_a(BOOK_GUI_TEXTURES);
        int i = (this.field_146294_l - this.getXSize()) / 2;
        int j = (this.field_146295_m - this.getYSize()) / 2;
        this.pageGrid.draw(this.field_146297_k, i, j);
        int originX = i + PAGE_MARGIN;
        int originY = j + PAGE_MARGIN - 5;
        List strs = FontUtil.drawSplitStringOverflow((FontRenderer)this.field_146289_q, (String)this.text, (int)originX, (int)originY, (int)this.getClientX(), (int)this.getClientY(), (int)0, (boolean)false);
        if (!strs.isEmpty()) {
            FontUtil.drawSplitStringOverflow((FontRenderer)this.field_146289_q, (List)strs, (int)(originX += PAGE_WIDTH / 2), (int)originY, (int)this.getClientX(), (int)this.getClientY(), (int)0, (boolean)false);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private int getXSize() {
        return PAGE_WIDTH;
    }

    private int getYSize() {
        return PAGE_HEIGHT;
    }

    private int getClientX() {
        return PAGE_WIDTH / 2 - 2 * PAGE_MARGIN + 5;
    }

    private int getClientY() {
        return PAGE_HEIGHT - 2 * PAGE_MARGIN;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                GuiConfirmOpenLink guiConfirm = new GuiConfirmOpenLink((GuiYesNoCallback)this, this.chatRoomURL, 3, true);
                guiConfirm.func_146358_g();
                this.field_146297_k.func_147108_a((GuiScreen)guiConfirm);
            } else if (button.field_146127_k == 1) {
                this.field_146297_k.func_147108_a(null);
            } else if (button.field_146127_k == 2) {
                GuiConfirmOpenLink guiConfirm = new GuiConfirmOpenLink((GuiYesNoCallback)this, this.mcmodWikiURL, 4, true);
                guiConfirm.func_146358_g();
                this.field_146297_k.func_147108_a((GuiScreen)guiConfirm);
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        if (result && (id == 3 || id == 4)) {
            try {
                Desktop.getDesktop().browse(new URI(id == 3 ? this.chatRoomURL : this.mcmodWikiURL));
            }
            catch (URISyntaxException wrongURI) {
                Cuisine.logger.error("The chat room link '{}' seems to be malformed", (Object)this.chatRoomURL);
                Cuisine.logger.debug("Exception caught: {}", (Throwable)wrongURI);
            }
            catch (Exception e) {
                Cuisine.logger.error("Couldn't open link", (Throwable)e);
            }
        }
        this.field_146297_k.func_147108_a(null);
    }
}

