/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.client;

import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.MaterialCategory;
import snownee.cuisine.client.gui.CuisineGUI;

@SideOnly(value=Side.CLIENT)
public class CulinaryRenderHelper {
    public static void renderMaterialCategoryIcon(MaterialCategory category, int x, int y) {
        CulinaryRenderHelper.renderMaterialCategoryIcon(category, x, y, 1.0, 0.0);
    }

    public static void renderMaterialCategoryIcon(MaterialCategory category, int x, int y, double level, double starvation) {
        float i;
        if (category.ordinal() > 10) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(CuisineGUI.TEXTURE_ICONS);
        int u = 96 + category.ordinal() * 16;
        if (level < 1.0) {
            Gui.func_146110_a((int)x, (int)y, (float)u, (float)32.0f, (int)16, (int)16, (float)256.0f, (float)256.0f);
        }
        if (level > 0.0) {
            Gui.func_146110_a((int)x, (int)y, (float)u, (float)0.0f, (int)((int)(level * 16.0)), (int)16, (float)256.0f, (float)256.0f);
        }
        if (starvation > 0.0 && (i = Math.abs((float)(Minecraft.func_71386_F() % 2000L) / 1000.0f - 1.0f)) != 0.0f) {
            if (i != 1.0f) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)i);
                GlStateManager.func_179112_b((int)770, (int)771);
            }
            Gui.func_146110_a((int)x, (int)y, (float)u, (float)16.0f, (int)((int)(starvation * 16.0)), (int)16, (float)256.0f, (float)256.0f);
            if (i != 1.0f) {
                GlStateManager.func_179084_k();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    public static void renderMaterialCategoryIcons(Map<MaterialCategory, Double> categoryToLevel, int x, int y, float starvationModifier, int maxWidth) {
        int width = 17;
        int sum = categoryToLevel.values().stream().mapToInt(MathHelper::func_76143_f).sum();
        if (sum == 0) {
            return;
        }
        if (sum * width > maxWidth) {
            width = maxWidth / sum;
        }
        sum = 0;
        for (Map.Entry<MaterialCategory, Double> entry : categoryToLevel.entrySet()) {
            double foodLevel = entry.getValue();
            int countIcon = MathHelper.func_76143_f((double)foodLevel);
            double starvation = foodLevel * (double)starvationModifier;
            for (int j = 0; j < countIcon; ++j) {
                CulinaryRenderHelper.renderMaterialCategoryIcon(entry.getKey(), x + sum * width, y, Math.min(1.0, foodLevel - (double)j), Math.min(1.0, starvation - (double)j));
                ++sum;
            }
        }
    }

    public static void renderIngredient(Minecraft mc, ItemStack stack, int doneness) {
        if (stack.func_77973_b() == CuisineRegistry.INGREDIENT || doneness <= 100) {
            CulinaryRenderHelper.renderColoredItem(mc, stack, ItemCameraTransforms.TransformType.NONE, -1, 0.0f, 0.0f);
        } else {
            CulinaryRenderHelper.renderColoredItem(mc, stack, ItemCameraTransforms.TransformType.NONE, Material.mixColor(-1, -16777216, (float)(doneness - 100) / 100.0f), 0.0f, 0.0f);
        }
    }

    public static void renderColoredItem(Minecraft mc, ItemStack stack, ItemCameraTransforms.TransformType transformType, int color, float x, float y) {
        RenderItem renderItem = mc.func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        IBakedModel bakedmodel = renderItem.func_184393_a(stack, mc.field_71439_g.func_130014_f_(), null);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        if (transformType != ItemCameraTransforms.TransformType.GUI || bakedmodel.func_177556_c()) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)transformType, (boolean)false);
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (bakedmodel.func_188618_c()) {
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
                GlStateManager.func_179091_B();
                stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
            } else {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
                ItemColors itemColors = mc.getItemColors();
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    CulinaryRenderHelper.renderQuads(bufferbuilder, bakedmodel.func_188616_a(null, enumfacing, 0L), color, itemColors, stack);
                }
                CulinaryRenderHelper.renderQuads(bufferbuilder, bakedmodel.func_188616_a(null, null, 0L), color, itemColors, stack);
                tessellator.func_78381_a();
                if (stack.func_77962_s()) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    renderItem.func_191966_a(bakedmodel);
                }
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179145_e();
    }

    private static void renderQuads(BufferBuilder buffer, List<BakedQuad> quads, int color, ItemColors itemColors, ItemStack stack) {
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            int k;
            BakedQuad bakedquad = quads.get(i);
            if (!stack.func_190926_b() && bakedquad.func_178212_b()) {
                k = itemColors.func_186728_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                float r = (float)(color >> 16 & 0xFF) / 255.0f * (float)(k >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f * (float)(k >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f * (float)(k & 0xFF) / 255.0f;
                k = (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
            } else {
                k = color;
            }
            LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)bakedquad, (int)k);
        }
    }

    public static void drawModalRect(float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        CulinaryRenderHelper.drawModalRect(x, y, u, v, width, height, textureWidth, textureHeight, 0.0f);
    }

    public static void drawModalRect(float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight, float z) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a((double)(u * f), (double)((v + height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)((u + width) * f), (double)((v + height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a((double)((u + width) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

