/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.client;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ColorizerFoliage;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.FoodContainer;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.Spice;
import snownee.cuisine.client.model.ChoppingBoardColorProxy;
import snownee.cuisine.internal.food.Drink;
import snownee.kiwi.util.NBTHelper;

@Mod.EventBusSubscriber(modid="cuisine", value={Side.CLIENT})
public final class CuisineItemRendering {
    public static final ResourceLocation EMPTY_MODEL = new ResourceLocation("cuisine", "empty");

    private CuisineItemRendering() {
        throw new UnsupportedOperationException("No instance for you");
    }

    @SubscribeEvent
    public static void onItemColorsInit(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        itemColors.func_186731_a((IItemColor)ChoppingBoardColorProxy.INSTANCE, new Block[]{CuisineRegistry.CHOPPING_BOARD});
        itemColors.func_186730_a((stack, tintIndex) -> {
            Material material;
            NBTTagCompound data;
            if (tintIndex == 0 && (data = stack.func_77978_p()) != null && (material = CulinaryHub.API_INSTANCE.findMaterial(data.func_74779_i("material"))) != null) {
                int doneness = data.func_74762_e("doneness");
                return material.getColorCode(doneness);
            }
            return -1;
        }, new Item[]{CuisineRegistry.INGREDIENT});
        itemColors.func_186730_a((stack, tintIndex) -> {
            FluidStack fluid;
            IFluidHandlerItem handler;
            if (tintIndex == 0 && CuisineRegistry.SPICE_BOTTLE.hasItem(stack)) {
                Spice spice = CuisineRegistry.SPICE_BOTTLE.getSpice(stack);
                if (spice != null) {
                    return spice.getColorCode();
                }
            } else if (tintIndex == 1 && CuisineRegistry.SPICE_BOTTLE.hasFluid(stack) && (handler = CuisineRegistry.SPICE_BOTTLE.getFluidHandler(stack)) != null && (fluid = handler.drain(Integer.MAX_VALUE, false)) != null) {
                return fluid.getFluid().getColor(fluid);
            }
            return -1;
        }, new Item[]{CuisineRegistry.SPICE_BOTTLE});
        itemColors.func_186730_a((stack, tintIndex) -> {
            if (tintIndex == 0) {
                FluidStack fluid;
                IFluidHandlerItem handlerItem = (IFluidHandlerItem)(stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (handlerItem != null && (fluid = handlerItem.drain(Integer.MAX_VALUE, false)) != null) {
                    return fluid.getFluid().getColor(fluid);
                }
                return NBTHelper.of((ItemStack)stack).getInt("liquidColor", -1);
            }
            return -1;
        }, new Item[]{CuisineRegistry.BOTTLE});
        itemColors.func_186730_a((stack, tintIndex) -> {
            if (tintIndex == 1 && stack.hasCapability(CulinaryCapabilities.FOOD_CONTAINER, null)) {
                FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
                CompositeFood food = container.get();
                if (food != null && food.getClass() == Drink.class) {
                    return ((Drink)food).getColor();
                }
                return NBTHelper.of((ItemStack)stack).getInt("liquidColor", -1);
            }
            return -1;
        }, new Item[]{CuisineRegistry.DRINK});
        itemColors.func_186731_a((stack, tintIndex) -> tintIndex == 0 ? ColorizerFoliage.func_77468_c() : -1, new Block[]{CuisineRegistry.SHEARED_LEAVES});
    }
}

