/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.tiles.TileDish;
import snownee.cuisine.util.StacksUtil;
import snownee.kiwi.block.BlockMod;

public class BlockPlacedDish
extends BlockMod {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.125, 0.0625, 0.125, 0.875, 0.09375, 0.875);
    private static final PropertyEnum<ModelType> MODEL = PropertyEnum.func_177709_a((String)"model_type", ModelType.class);

    public BlockPlacedDish(String name) {
        super(name, Material.field_151571_B);
        this.func_149647_a(Cuisine.CREATIVE_TAB);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(MODEL, (Comparable)((Object)ModelType.EMPTY)));
    }

    public int getItemSubtypeAmount() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void mapModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileDish) {
            return ((TileDish)te).onEatenBy(playerIn);
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (this.canBlockStay(worldIn, pos)) {
            return super.func_176196_c(worldIn, pos);
        }
        return false;
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileDish) {
            return state.func_177226_a(MODEL, (Comparable)((Object)ModelType.of(((TileDish)te).getDishModelType())));
        }
        return state.func_177226_a(MODEL, (Comparable)((Object)ModelType.EMPTY));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MODEL});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileDish) {
            return ((TileDish)te).getItem();
        }
        return new ItemStack((Block)CuisineRegistry.PLACED_DISH);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack stack;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileDish && !(stack = ((TileDish)te).getItem()).func_190926_b()) {
            StacksUtil.spawnItemStack(worldIn, pos, stack, true);
        }
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World worldIn, IBlockState meta) {
        return new TileDish();
    }

    static enum ModelType implements IStringSerializable
    {
        FISH_0,
        RICE_0,
        MEAT_0,
        MEAT_1,
        VEGES_0,
        VEGES_1,
        MIXED_0,
        MIXED_1,
        EMPTY;


        public String func_176610_l() {
            return this.toString().toLowerCase().replace("_", "");
        }

        static ModelType of(String s) {
            switch (s) {
                case "fish0": {
                    return FISH_0;
                }
                case "rice0": {
                    return RICE_0;
                }
                case "meat0": {
                    return MEAT_0;
                }
                case "meat1": {
                    return MEAT_1;
                }
                case "veges0": {
                    return VEGES_0;
                }
                case "veges1": {
                    return VEGES_1;
                }
                case "mixed0": {
                    return MIXED_0;
                }
                case "mixed1": {
                    return MIXED_1;
                }
            }
            return EMPTY;
        }
    }
}

