/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.items.ItemMortar;
import snownee.cuisine.tiles.TileMortar;
import snownee.cuisine.util.StacksUtil;
import snownee.kiwi.block.BlockModHorizontal;

public class BlockMortar
extends BlockModHorizontal {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.0625, 0.1875, 0.8125, 0.3125, 0.8125);
    private static final PropertyBool PESTLE_DOWN = PropertyBool.func_177716_a((String)"pestle");

    public BlockMortar(String name) {
        super(name, Material.field_151576_e);
        this.func_149647_a(Cuisine.CREATIVE_TAB);
        this.func_149711_c(0.2f);
        this.func_180632_j(super.func_176223_P().func_177226_a((IProperty)PESTLE_DOWN, (Comparable)Boolean.FALSE));
    }

    public boolean hasItem() {
        return false;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D, PESTLE_DOWN});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileMortar) {
            return state.func_177226_a((IProperty)PESTLE_DOWN, (Comparable)(((TileMortar)tile).pestle ? Boolean.TRUE : Boolean.FALSE));
        }
        return state.func_177226_a((IProperty)PESTLE_DOWN, (Comparable)Boolean.FALSE);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileMortar) {
            TileMortar mortar = (TileMortar)te;
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (heldItem.func_190926_b()) {
                if (playerIn.func_70093_af()) {
                    StacksUtil.dropInventoryItems(worldIn, pos, (IItemHandler)mortar.stacks, false);
                } else {
                    playerIn.func_71020_j(0.1f);
                    mortar.process(playerIn);
                    worldIn.func_184138_a(pos, state, state, 3);
                }
            } else if (heldItem.func_77973_b() != CuisineRegistry.ITEM_MORTAR) {
                heldItem = mortar.insertItem(heldItem);
                playerIn.func_184611_a(hand, heldItem);
            }
            return true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileMortar) {
            StacksUtil.dropInventoryItems(worldIn, pos, (IItemHandler)((TileMortar)te).stacks, true);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileMortar();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return CuisineRegistry.ITEM_MORTAR.getItemStack(ItemMortar.Variant.EMPTY);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return CuisineRegistry.ITEM_MORTAR;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileMortar && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)));
        }
        return 0;
    }
}

