/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.cuisine.Cuisine;
import snownee.cuisine.world.feature.WorldFeatureCitrusGenusTree;
import snownee.kiwi.block.IModBlock;

public class BlockModSapling
extends BlockBush
implements IModBlock,
IGrowable {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"variant", Type.class);
    private static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);
    private final String name;

    public BlockModSapling(String name) {
        this.name = name;
        this.func_149647_a(Cuisine.CREATIVE_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.POMELO)).func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public Block cast() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void register(String modid) {
        this.setRegistryName(modid, this.getName());
        this.func_149663_c(modid + "." + this.getName());
    }

    public int getItemSubtypeAmount() {
        return 7;
    }

    @SideOnly(value=Side.CLIENT)
    public void mapModel() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSapling.field_176479_b}).func_178441_a());
        Item item = Item.func_150898_a((Block)this);
        Type[] values = Type.values();
        for (int i = 0; i < values.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("cuisine", "sapling_" + values[i].func_176610_l()), "inventory"));
        }
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < this.getItemSubtypeAmount(); ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta / 2])).func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(meta % 2));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).ordinal() * 2 + (Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b);
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, BlockSapling.field_176479_b});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (world.func_175697_a(pos, 1) && world.func_175671_l(pos.func_177984_a()) > 8 && rand.nextInt(8) == 0) {
                if ((Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b) == 0) {
                    world.func_180501_a(pos, state.func_177231_a((IProperty)BlockSapling.field_176479_b), 4);
                } else {
                    this.growIntoTree(world, rand, pos, state);
                }
            }
        }
    }

    private void growIntoTree(World world, Random rand, BlockPos pos, IBlockState state) {
        if (TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
            if (!new WorldFeatureCitrusGenusTree(true, (Type)((Object)state.func_177229_b(VARIANT)), false).func_180709_b(world, rand, pos)) {
                world.func_180501_a(pos, state, 4);
            }
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return world.field_73012_v.nextDouble() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b) == 0) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(1)));
        } else {
            this.growIntoTree(worldIn, rand, pos, state);
        }
    }

    public static enum Type implements IStringSerializable
    {
        POMELO,
        CITRON,
        MANDARIN,
        GRAPEFRUIT,
        ORANGE,
        LEMON,
        LIME;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

