/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.blocks.BlockModSapling;
import snownee.cuisine.blocks.BlockShearedLeaves;
import snownee.cuisine.items.ItemBasicFood;
import snownee.cuisine.library.RarityManager;
import snownee.cuisine.tiles.TileFruitTree;
import snownee.cuisine.util.StacksUtil;
import snownee.kiwi.block.BlockMod;

@Mod.EventBusSubscriber(modid="cuisine")
public class BlockModLeaves
extends BlockMod
implements IGrowable,
IShearable {
    public static final PropertyBool CORE = PropertyBool.func_177716_a((String)"core");
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    private final ItemBasicFood.Variant fruit;
    private static int[] surroundings;
    public static boolean passable;

    public BlockModLeaves(String name, ItemBasicFood.Variant fruit) {
        super(name, Material.field_151584_j);
        this.func_149675_a(true);
        this.func_149647_a(Cuisine.CREATIVE_TAB);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CORE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
        this.fruit = fruit;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        if (event.getState().func_177230_c() == this && (Integer)event.getState().func_177229_b((IProperty)AGE) == 3) {
            event.getDrops().add(BlockModLeaves.getDrop(this.fruit));
        }
    }

    private static ItemStack getDrop(ItemBasicFood.Variant fruit) {
        ItemStack drop = CuisineRegistry.BASIC_FOOD.getItemStack(fruit);
        if (RANDOM.nextInt(10) == 0) {
            RarityManager.setRarity(drop, drop.func_77953_t().ordinal() + 1);
        }
        return drop;
    }

    @SideOnly(value=Side.CLIENT)
    public void mapModel() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{CORE}).func_178442_a(new IProperty[]{BlockLeaves.field_176236_b}).func_178441_a());
    }

    public boolean hasItem() {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CORE, AGE, BlockLeaves.field_176236_b});
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)AGE);
        if (((Boolean)state.func_177229_b((IProperty)CORE)).booleanValue()) {
            meta |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta % 4));
        if ((meta & 4) != 0) {
            state = state.func_177226_a((IProperty)CORE, (Comparable)Boolean.valueOf(true));
        }
        if ((meta & 8) != 0) {
            state = state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)this.getItemInternal(world.func_180495_p(pos)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CORE);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileFruitTree(this.getFruitType());
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        if (!(CuisineConfig.GENERAL.fruitDrops && worldIn.func_82736_K().func_82766_b("doTileDrops") || (Integer)state.func_177229_b((IProperty)AGE) != 3)) {
            return false;
        }
        return (Integer)state.func_177229_b((IProperty)AGE) > 0;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) != 3 && worldIn.field_73012_v.nextFloat() < 0.7f;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 3) {
            worldIn.func_175656_a(pos, this.onPassiveGathered(worldIn, pos, state));
            BlockModLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)BlockModLeaves.getDrop(this.fruit));
        } else {
            worldIn.func_175656_a(pos, state.func_177231_a((IProperty)AGE));
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_175727_C(pos.func_177984_a()) && !worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && rand.nextInt(15) == 1) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149730_j(IBlockState state) {
        return true;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return this.getItemInternal(state);
    }

    private ItemStack getItemInternal(IBlockState state) {
        return CuisineRegistry.SHEARED_LEAVES.getItemInternal(this.getShearedState(state));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        CuisineRegistry.SHEARED_LEAVES.getDrops(drops, world, pos, this.getShearedState(state), fortune);
    }

    private BlockModSapling.Type getFruitType() {
        if (this.fruit == ItemBasicFood.Variant.CITRON) {
            return BlockModSapling.Type.CITRON;
        }
        if (this.fruit == ItemBasicFood.Variant.LEMON) {
            return BlockModSapling.Type.LEMON;
        }
        if (this.fruit == ItemBasicFood.Variant.LIME) {
            return BlockModSapling.Type.LIME;
        }
        if (this.fruit == ItemBasicFood.Variant.MANDARIN) {
            return BlockModSapling.Type.MANDARIN;
        }
        if (this.fruit == ItemBasicFood.Variant.GRAPEFRUIT) {
            return BlockModSapling.Type.GRAPEFRUIT;
        }
        if (this.fruit == ItemBasicFood.Variant.ORANGE) {
            return BlockModSapling.Type.ORANGE;
        }
        return BlockModSapling.Type.POMELO;
    }

    private IBlockState getShearedState(IBlockState state) {
        IBlockState newState = CuisineRegistry.SHEARED_LEAVES.func_176223_P();
        if ((Integer)state.func_177229_b((IProperty)AGE) == 2) {
            newState = newState.func_177226_a((IProperty)BlockShearedLeaves.FLOWER, (Comparable)Boolean.valueOf(true));
        }
        return newState.func_177226_a(BlockModSapling.VARIANT, (Comparable)((Object)this.getFruitType()));
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return this.getItemInternal(state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 3 && worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)))) {
            if (playerIn instanceof FakePlayer) {
                StacksUtil.spawnItemStack(worldIn, pos, BlockModLeaves.getDrop(this.fruit), true);
            } else {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)BlockModLeaves.getDrop(this.fruit));
            }
            return true;
        }
        return false;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)), 4);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        int i1;
        int l;
        int k = pos.func_177958_n();
        if (worldIn.func_175707_a(new BlockPos(k - 2, (l = pos.func_177956_o()) - 2, (i1 = pos.func_177952_p()) - 2), new BlockPos(k + 2, l + 2, i1 + 2))) {
            for (int j1 = -1; j1 <= 1; ++j1) {
                for (int k1 = -1; k1 <= 1; ++k1) {
                    for (int l1 = -1; l1 <= 1; ++l1) {
                        BlockPos blockpos = pos.func_177982_a(j1, k1, l1);
                        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                        if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, blockpos)) continue;
                        iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
                    }
                }
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            if (((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue()) {
                int l2;
                int k = pos.func_177958_n();
                int l = pos.func_177956_o();
                int i1 = pos.func_177952_p();
                if (surroundings == null) {
                    surroundings = new int[32768];
                }
                if (!worldIn.func_175697_a(pos, 1)) {
                    return;
                }
                if (worldIn.func_175697_a(pos, 6)) {
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                    for (int i2 = -4; i2 <= 4; ++i2) {
                        for (int j2 = -4; j2 <= 4; ++j2) {
                            for (int k2 = -4; k2 <= 4; ++k2) {
                                IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2));
                                Block block = iblockstate.func_177230_c();
                                if (!block.canSustainLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2))) {
                                    if (block.isLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2))) {
                                        BlockModLeaves.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -2;
                                        continue;
                                    }
                                    BlockModLeaves.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -1;
                                    continue;
                                }
                                BlockModLeaves.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = 0;
                            }
                        }
                    }
                    for (int i3 = 1; i3 <= 4; ++i3) {
                        for (int j3 = -4; j3 <= 4; ++j3) {
                            for (int k3 = -4; k3 <= 4; ++k3) {
                                for (int l3 = -4; l3 <= 4; ++l3) {
                                    if (surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16] != i3 - 1) continue;
                                    if (surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                        BlockModLeaves.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                    }
                                    if (surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                        BlockModLeaves.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                    }
                                    if (surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] == -2) {
                                        BlockModLeaves.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] = i3;
                                    }
                                    if (surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] == -2) {
                                        BlockModLeaves.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] = i3;
                                    }
                                    if (surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + (l3 + 16 - 1)] == -2) {
                                        BlockModLeaves.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + (l3 + 16 - 1)] = i3;
                                    }
                                    if (surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] != -2) continue;
                                    BlockModLeaves.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] = i3;
                                }
                            }
                        }
                    }
                }
                if ((l2 = surroundings[16912]) >= 0) {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), 4);
                } else {
                    this.func_176226_b(worldIn, pos, state, 0);
                    worldIn.func_175698_g(pos);
                }
            } else if (this.func_176473_a(worldIn, pos, state, false) && worldIn.func_175697_a(pos, 1) && worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
                boolean def;
                boolean bl = def = rand.nextInt(100) > 99 - CuisineConfig.GENERAL.fruitGrowingSpeed;
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)def)) {
                    this.func_176474_b(worldIn, rand, pos, state);
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
                }
            }
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        if (!passable && entityIn != null && !(entityIn instanceof EntityItem)) {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        if (!worldIn.field_72995_K && fallDistance >= 1.0f && entityIn instanceof EntityLivingBase) {
            for (BlockPos pos2 : BlockPos.func_191531_b((int)(pos.func_177958_n() - 1), (int)Math.max(0, pos.func_177956_o() - 2), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() + 1))) {
                IBlockState state = worldIn.func_180495_p(pos2);
                if (!(state.func_177230_c() instanceof BlockModLeaves) || (Integer)state.func_177229_b((IProperty)AGE) != 3) continue;
                ((BlockModLeaves)state.func_177230_c()).func_176474_b(worldIn, worldIn.field_73012_v, pos2, state);
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && state.func_177230_c() == CuisineRegistry.LEAVES_CITRON && blockIn == Blocks.field_150350_a && fromPos.equals((Object)pos.func_177984_a()) && worldIn.func_180495_p(fromPos).func_177230_c() == Blocks.field_150480_ab) {
            worldIn.func_175698_g(fromPos);
            boolean flag = false;
            for (Entity entity : worldIn.field_73007_j) {
                if (!(entity instanceof EntityLightningBolt) || !entity.func_180425_c().equals((Object)fromPos)) continue;
                flag = true;
            }
            if (!flag) {
                return;
            }
            for (BlockPos pos2 : BlockPos.func_191531_b((int)(pos.func_177958_n() - 3), (int)(pos.func_177956_o() - 3), (int)(pos.func_177952_p() - 3), (int)(pos.func_177958_n() + 3), (int)(pos.func_177956_o() + 3), (int)(pos.func_177952_p() + 3))) {
                IBlockState state2 = worldIn.func_180495_p(pos2);
                if (state2.func_177230_c() != this || (Integer)state2.func_177229_b((IProperty)AGE) != 3) continue;
                worldIn.func_175656_a(pos2, this.onPassiveGathered(worldIn, pos2, state2));
                if (!worldIn.func_82736_K().func_82766_b("doTileDrops") || worldIn.restoringBlockSnapshots) continue;
                ItemStack stack = BlockModLeaves.getDrop(ItemBasicFood.Variant.EMPOWERED_CITRON);
                if (((Boolean)captureDrops.get()).booleanValue()) {
                    ((NonNullList)capturedDrops.get()).add((Object)stack);
                    continue;
                }
                double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
                EntityItem entityitem = new EntityItem(worldIn, (double)pos2.func_177958_n() + d0, (double)pos2.func_177956_o() + d1, (double)pos2.func_177952_p() + d2, stack);
                entityitem.func_174869_p();
                entityitem.func_184224_h(true);
                worldIn.func_72838_d((Entity)entityitem);
                EntityBat bat = new EntityBat(worldIn);
                bat.func_70107_b((double)pos2.func_177958_n() + d0, (double)pos2.func_177956_o() + d1, (double)pos2.func_177952_p() + d2);
                bat.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 10));
                bat.func_96094_a("ForestBat");
                bat.func_174805_g(true);
                worldIn.func_72838_d((Entity)bat);
            }
        }
    }

    private IBlockState onPassiveGathered(World world, BlockPos pos, IBlockState state) {
        int death = 30;
        for (BlockPos pos2 : BlockPos.func_191531_b((int)(pos.func_177958_n() - 2), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 2), (int)(pos.func_177958_n() + 2), (int)(pos.func_177956_o() + 2 + 1), (int)(pos.func_177952_p() + 2))) {
            TileEntity tile = world.func_175625_s(pos2);
            if (!(tile instanceof TileFruitTree)) continue;
            death = ((TileFruitTree)tile).updateDeathRate();
            break;
        }
        if (death >= 50 || world.field_73012_v.nextInt(50) < death) {
            return state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0));
        }
        return state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1));
    }

    static {
        passable = false;
        if (Loader.isModLoaded((String)"passableleaves") || CuisineConfig.GENERAL.passableLeaves) {
            passable = true;
        }
    }
}

