/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.cuisine.Cuisine;
import snownee.cuisine.tiles.TileMill;
import snownee.cuisine.util.StacksUtil;
import snownee.kiwi.block.BlockModHorizontal;

public class BlockMill
extends BlockModHorizontal {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.525, 0.875);

    public BlockMill(String name) {
        super(name, Material.field_151576_e);
        this.func_149647_a(Cuisine.CREATIVE_TAB);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.setDefaultDirection(worldIn, pos, state);
    }

    private void setDefaultDirection(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            boolean flag = worldIn.func_180495_p(pos.func_177978_c()).func_185913_b();
            boolean flag1 = worldIn.func_180495_p(pos.func_177968_d()).func_185913_b();
            if (enumfacing == EnumFacing.NORTH && flag && !flag1) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && flag1 && !flag) {
                enumfacing = EnumFacing.NORTH;
            } else {
                boolean flag2 = worldIn.func_180495_p(pos.func_177976_e()).func_185913_b();
                boolean flag3 = worldIn.func_180495_p(pos.func_177974_f()).func_185913_b();
                if (enumfacing == EnumFacing.WEST && flag2 && !flag3) {
                    enumfacing = EnumFacing.EAST;
                } else if (enumfacing == EnumFacing.EAST && flag3 && !flag2) {
                    enumfacing = EnumFacing.WEST;
                }
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)enumfacing), 2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileMill)) {
            return false;
        }
        ItemStack held = playerIn.func_184586_b(hand);
        if (held.func_190926_b()) {
            if (hand != EnumHand.MAIN_HAND) return false;
            if (playerIn.func_70093_af()) {
                if (worldIn.field_72995_K) return true;
                StacksUtil.spawnItemStack(worldIn, pos, ((TileMill)te).getItemContent(), true);
                worldIn.func_175666_e(pos, (Block)this);
                return true;
            } else {
                ((TileMill)te).onRightClicked(playerIn);
            }
            return true;
        } else {
            if (worldIn.field_72995_K) return true;
            if (FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)pos, (EnumFacing)facing)) {
                return true;
            }
            playerIn.func_184611_a(hand, ((TileMill)te).tryInsertItem(held));
            worldIn.func_175666_e(pos, (Block)this);
        }
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BlockHorizontal.field_185512_D, Properties.StaticProperty}, new IUnlistedProperty[]{Properties.AnimationProperty});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileMill();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileMill) {
            StacksUtil.spawnItemStack(worldIn, pos, ((TileMill)tileentity).getItemContent(), true);
            ((TileMill)tileentity).spillFluids();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileMill && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)));
        }
        return 0;
    }
}

