/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.cuisine.Cuisine;
import snownee.cuisine.tiles.TileJar;
import snownee.cuisine.util.StacksUtil;
import snownee.kiwi.block.BlockMod;

public class BlockJar
extends BlockMod {
    public static final PropertyInteger VARIANT = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)3);
    private static final AxisAlignedBB AABB_TOP = new AxisAlignedBB(0.1875, 0.6875, 0.1875, 0.8125, 0.9375, 0.8125);
    private static final AxisAlignedBB AABB_BOTTOM = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.6875, 0.9375);
    private static final AxisAlignedBB AABB_FULL = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);

    public BlockJar(String name) {
        super(name, Material.field_151571_B);
        this.func_149647_a(Cuisine.CREATIVE_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(1.25f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileJar)) {
            return false;
        }
        ItemStack held = playerIn.func_184586_b(hand);
        if (held.func_190926_b()) {
            if (worldIn.field_72995_K || hand != EnumHand.MAIN_HAND) {
                return false;
            }
        } else {
            ItemStack heldCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)held, (int)1);
            if (FluidUtil.getFluidHandler((ItemStack)heldCopy) != null) {
                return FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)pos, (EnumFacing)facing);
            }
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
            if (handler != null) {
                playerIn.func_184611_a(hand, ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)held, (boolean)false));
                worldIn.func_175666_e(pos, (Block)this);
            }
            return true;
        }
        StacksUtil.dropInventoryItems(worldIn, pos, (IItemHandler)((TileJar)te).stacks, true);
        worldIn.func_175666_e(pos, (Block)this);
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(4)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VARIANT);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockJar.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_TOP);
        BlockJar.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BOTTOM);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_FULL;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileJar();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileJar) {
            StacksUtil.dropInventoryItems(worldIn, pos, (IItemHandler)((TileJar)te).stacks, true);
            ((TileJar)te).spillFluids();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileJar && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)));
        }
        return 0;
    }
}

